/**
 * Common Library
 * CL_PAY Common Lib PAY
 */
;(function (root, factory, undefined) {
    'use strict';
    if (typeof define === 'function' && define.amd) {
        // AMD
        define(['jquery'], function (jquery) {
            return (root.CL_PAY = factory(jquery));
        });
    } else if (typeof exports === 'object' && module.exports) {
        // CommonJS
        module.exports = factory(require('jquery'));
    } else {
        root.CL_PAY = factory(root.jQuery);
    }
}(this, function ($, undefined) {
    'use strict';
    /*
    // Todo native bridge
    */
    var pushMessage = function (obj) {
        if (Object.keys(obj).length === 0) return;

        if (obj.code) {
            setAuthAutofill(obj);
        }
        if (obj.name || obj.phone ) {
            // 하이픈 제거
            obj.phone = obj.phone.split("-").join("");
            setUserInfoAutofill(obj);
        }
    }

    var setAuthAutofill = function (obj) {
        $(".individual #bnum").val(obj.code).hide().fadeIn('slow');
    }

    var setUserInfoAutofill = function (obj) {
        $("#dname").fadeOut('fast').fadeIn('slow').val(obj.name);
        $("#dtel").fadeOut('fast').fadeIn('slow').val(obj.phone);
    }

    return {
        pushMessage: pushMessage,
        setAuthAutofill: setAuthAutofill,
        setUserInfoAutofill: setUserInfoAutofill
    };
}));


/**
 * CL Common Library
 */
;(function (root, factory, undefined) {
    'use strict';

    if (typeof define === 'function' && define.amd) {
        // AMD
        define(['jquery'], function (jquery) {
            return (root.CL = factory(jquery));
        });
    } else if (typeof exports === 'object' && module.exports) {
        // CommonJS
        module.exports = factory(require('jquery'));
    } else {
        root.CL = factory(root.jQuery);
    }
}(this, function ($, undefined) {
    'use strict';
    //--
    // util
    //--
    /**
     * get QueryString parameters
     * @param string url - full url
     * @param string q_mark - optional question mark
     */
    var queryParams = function(url, q_mark) {
        url = '' + url;
        var hashes = url.slice(url.indexOf((q_mark) ? q_mark : '?') + 1).split('&');
        var len = hashes.length;

        var pair = '';
        var params = {};
        for (var i = 0; i < len; i++) {
            pair = hashes[i].split('=');
            var key = decodeURIComponent(pair[0]); // key
            if (key === url) break; // no param
            var val = decodeURIComponent(pair[1]); // val
            if (key) {
                if (key.indexOf('[]') === -1) {
                    params[key] = val;
                    continue;
                }

                var arr = (Array.isArray(params[key])) ? params[key] : [];
                arr.push(val);
                params[key] = arr;
            }
        }
        return params;
    }

    /**
     * Native bridge
     * @param type  int - native call case
     * 1001: 주소검색
     * 1002: 본인인증
     * 1003: 쿠폰 팝업 닫기
     * 1004: 장바구니 수 갱신
     * 1005: 프로모션 웹뷰 닫기
     * 1006: 본인인증 타계정 존재
     * 1007: 본인인증 미완료 안내
     * 1008: 애드브릭스
     * 1009: 점유인증 진행중
     * 1010: 점유인증 만료
     * 1011: 연락처 호출
     * @param msg   str - data
     */
    function callNative(type, data, AGENT) {
        var NATIVE_NS = 'Native'; // native name space
        var FUNC_NAME = 'onJsResponse'; // only UIWebview

        var type = (type) ? Number(type) : 0; // cast int
        var msg = '';
        try {
            if (typeof data === 'object') msg = JSON.stringify(data);
            else if (typeof data === 'undefined') msg = '';
            else msg = ('' + data);

            if (AGENT === 'ios') {
                // window.webkit.messageHandlers.Native.postMessage({'type': type, 'msg': msg});
                window.webkit.messageHandlers[NATIVE_NS].postMessage({'type': type, 'msg': msg});
            } else if (AGENT === 'android') {
                //window.Native.onJsResponse(type, msg);
                window[NATIVE_NS][FUNC_NAME](type, msg);
            } else if (AGENT === 'web') {
                // WEBVIEW
                console.log('callNative: ', type, data, AGENT);
            }
        } catch (e) {
            console.log(e);
        }
        return true;
    }

    //--
    // public(closure)
    //--
    return {
        // util
        queryParams: queryParams,
        callNative: callNative,
    };
}));

