<?php

namespace platyFramework;

class ptyDateTime
{
}

/**
 * 과거일 경우 -, 지났을 경우 +
 *
 * @param string $datetime
 * @return int|null
 */
function ptyGetPassedMinutes(string $datetime)
{
    try {
        // 현재 시간 가져오기
        $now = new \DateTime();

        // 입력된 날짜를 DateTime 객체로 변환
        $date = new \DateTime($datetime);

        // 현재 시간과 입력된 시간의 차이를 계산
        $diff = $now->getTimestamp() - $date->getTimestamp();
        $passMinute = floor($diff / 60); // 초 단위 차이를 분 단위로 변환

        return (int)$passMinute;
    } catch (\Exception $e) {
        // 예외 발생 시 false 반환, $passMinute은 -1로 설정
        return null;
    }
}


/**
 * 일자만으로 차이 비교, 과거일 경우 -, 지났을 경우 +
 *
 * @param string $datetime
 * @return int|null
 */
function ptyGetPassedDay(string $datetime)
{
    try {
        $date = new \DateTime($datetime);
        $datetime = $date->format('Y-m-d');

        // 현재 시간 가져오기
        $now = new \DateTime();

        // 입력된 날짜를 DateTime 객체로 변환
        $date = new \DateTime($datetime);

        // 현재 시간과 입력된 시간의 차이를 계산
        $diff = $now->diff($date);

        // 날짜 차이를 일(day) 단위로 반환
        $passDays = (int)$diff->format('%r%a'); // %r: 음수일 경우 부호를 유지, %a: 전체 일 수

        return (int)$passDays;
    } catch (\Exception $e) {
        // 예외 발생 시 false 반환, $passMinute은 -1로 설정
        return null;
    }
}

/**
 * 특정 시간의 '오전', '오후' 리턴
 * @param string $s
 * @return string '오전, 오후"
 * @throws \DateMalformedStringException
 */
function ptyGetAmPm(string $s)
{
    return ($amPm = (new \DateTime($s))->format('A') === 'AM' ? '오전' : '오후') . ' ' . (new \DateTime($s))->format('g시 i분');
}


?>