#!/bin/bash

#######################################
# CentOS 초기 설정 스크립트
# 사용법: ./setup_centos.sh
#######################################

set -e  # 에러 발생 시 스크립트 중단

# 색상 정의
CYAN='\033[0;36m'
BLUE='\033[1;94m'  # 밝은 파란색
PURPLE='\033[0;35m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
RED='\033[0;31m'
NC='\033[0m' # No Color

# 로고 출력
clear
echo -e "${CYAN}"
cat << "EOF"
    ____  __    ___  __________  __  __    ____  __  _______  ______
   / __ \/ /   /   |/_  __/\ \ / / / / /  / __ \/ / / / ___/ / ____/
  / /_/ / /   / /| | / /    \ V / / /_/ / / / / / / /\__ \ / __/   
 / ____/ /___/ ___ |/ /      | / / __  / / /_/ / /_/ /___/ / /___   
/_/   /_____/_/  |_/_/       |_/_/ /_/  \____/\____//____/ /_____/   
EOF
echo -e "${NC}"
echo -e "${PURPLE}═══════════════════════════════════════════════════════════${NC}"
echo -e "${BLUE}          CentOS 초기 설정 자동화 스크립트 v1.0${NC}"
echo -e "${PURPLE}═══════════════════════════════════════════════════════════${NC}"
echo ""

#######################################
# 1. 호스트명 설정
#######################################
CURRENT_HOSTNAME=$(hostnamectl --static)
echo -e "${CYAN}[1/5]${NC} 호스트명 설정, 현재 호스트명: ${YELLOW}${CURRENT_HOSTNAME}${NC}"
echo -e "${YELLOW}호스트명을 변경하시겠습니까? (N/y):${NC} \c"
read -n 1 -r REPLY_HOSTNAME
echo
if [[ $REPLY_HOSTNAME =~ ^[Yy]$ ]]; then
    echo -e "${YELLOW}설정할 호스트명을 입력하세요:${NC} \c"
    read HOSTNAME
    if [ -n "$HOSTNAME" ]; then
        hostnamectl set-hostname "$HOSTNAME"
        echo -e "  ${GREEN}✓${NC} 호스트명이 설정되었습니다: ${YELLOW}$(hostnamectl --static)${NC}"
    else
        echo -e "  ${YELLOW}⊘${NC} 호스트명이 입력되지 않아 건너뜁니다."
    fi
else
    echo -e "  ${YELLOW}⊘${NC} 건너뛰기"
fi
echo ""

#######################################
# 2. /etc/bashrc 설정
#######################################
echo -e "${CYAN}[2/5]${NC} /etc/bashrc 설정 추가"
echo -e "${YELLOW}/etc/bashrc에 커스텀 설정을 추가하시겠습니까? (N/y):${NC} \c"
read -n 1 -r REPLY_BASHRC
echo
if [[ $REPLY_BASHRC =~ ^[Yy]$ ]]; then
    # 백업 생성
    cp /etc/bashrc /etc/bashrc.backup.$(date +%Y%m%d_%H%M%S)

    # bashrc에 추가할 내용
    cat >> /etc/bashrc << 'EOF'

#######################################
# 커스텀 설정
#######################################

# 프롬프트 색상 설정
export PS1='\[\033[01;32m\]\u@\h\[\033[00m\]:\[\033[01;34m\]\w\[\033[00m\]\$ '

# 히스토리 설정
export HISTSIZE=10000
export HISTFILESIZE=20000
export HISTTIMEFORMAT="%Y-%m-%d %H:%M:%S "

# 기본 에디터 설정
export EDITOR=vi

# 유용한 alias
alias ll='ls -alF'
alias la='ls -A'
alias l='ls -CF'
alias grep='grep --color=auto'
alias df='df -h'
alias du='du -h'

EOF

    echo -e "  ${GREEN}✓${NC} /etc/bashrc 설정이 완료되었습니다."
else
    echo -e "  ${YELLOW}⊘${NC} 건너뛰기"
fi
echo ""

#######################################
# 3. YUM 캐시 정리
#######################################
echo -e "${CYAN}[3/5]${NC} YUM 캐시 정리"
echo -e "${YELLOW}YUM 캐시를 정리하시겠습니까? (N/y):${NC} \c"
read -n 1 -r REPLY_YUM_CLEAN
echo
if [[ $REPLY_YUM_CLEAN =~ ^[Yy]$ ]]; then
    yum clean all > /dev/null 2>&1
    rm -rf /var/cache/yum
    echo -e "  ${GREEN}✓${NC} YUM 캐시가 정리되었습니다."
else
    echo -e "  ${YELLOW}⊘${NC} 건너뛰기"
fi
echo ""

#######################################
# 4. 시스템 업데이트
#######################################
echo -e "${CYAN}[4/5]${NC} 시스템 패키지 업데이트"
echo -e "${YELLOW}시스템 업데이트를 진행하시겠습니까? (N/y):${NC} \c"
read -n 1 -r REPLY_UPDATE
echo
if [[ $REPLY_UPDATE =~ ^[Yy]$ ]]; then
    yum update -y
    echo -e "  ${GREEN}✓${NC} 시스템 업데이트가 완료되었습니다."
else
    echo -e "  ${YELLOW}⊘${NC} 건너뛰기"
fi
echo ""

#######################################
# 5. 필수 패키지 설치
#######################################
echo -e "${CYAN}[5/5]${NC} 필수 패키지 설치"
echo -e "${YELLOW}필수 패키지를 설치하시겠습니까? (vim, wget, curl, net-tools 등) (N/y):${NC} \c"
read -n 1 -r REPLY_PACKAGES
echo
if [[ $REPLY_PACKAGES =~ ^[Yy]$ ]]; then
    yum install -y \
        vim \
        wget \
        curl \
        net-tools \
        bind-utils \
        telnet \
        tcpdump > /dev/null 2>&1

    echo -e "  ${GREEN}✓${NC} 필수 패키지 설치가 완료되었습니다."
else
    echo -e "  ${YELLOW}⊘${NC} 건너뛰기"
fi
echo ""

#######################################
# 완료
#######################################
echo -e "${PURPLE}═══════════════════════════════════════════════════════════${NC}"
echo -e "${GREEN}✓ CentOS 초기 설정이 완료되었습니다!${NC}"
echo -e "${PURPLE}═══════════════════════════════════════════════════════════${NC}"
echo ""
echo -e "  ${CYAN}▶${NC} 현재 호스트명: ${YELLOW}$(hostnamectl --static)${NC}"
echo ""
echo -e "${YELLOW}[알림]${NC} 변경사항 적용을 위해 다음 중 하나를 실행하세요:"
echo -e "  ${BLUE}1.${NC} 쉘 재시작"
echo -e "  ${BLUE}2.${NC} source /etc/bashrc"
echo ""
echo -e "${PURPLE}═══════════════════════════════════════════════════════════${NC}"
