<?php
$rootDir = $argv[1];

function getLastModifiedDate($dir, &$fileName) {
    $latestDate = null;
    $files = glob($dir . '/*');
    
    foreach ($files as $file) {
        if (is_dir($file)) {
            $date = getLastModifiedDate($file);
            if ($date !== null && ($latestDate === null || $date > $latestDate)) {
                $latestDate = $date;
		$fileName = $file;
            }
        } else {
            $fileDate = filemtime($file);
            if ($latestDate === null || $fileDate > $latestDate) {
                $latestDate = $fileDate;
		$fileName = $file;
            }
        }
    }
    
    return $latestDate;
}

function formatTimestamp($timestamp) {
    return date('Y-m-d H:i:s', $timestamp);
}

$lastFile = [];

// 하위 폴더의 마지막 수정 날짜 얻기
function getLastModifiedDates($dir) {
	global $lastFile;

    $subDirs = glob($dir . '/*', GLOB_ONLYDIR);
    $lastModifiedDates = [];
    
    foreach ($subDirs as $subDir) {
	echo "\r\033[K"."scanning = $subDir";
        $lastModifiedDates[$subDir] = formatTimestamp(getLastModifiedDate($subDir, $fileName));
	$lastFile[$subDir] = $fileName;
    }
    
    return $lastModifiedDates;
}

$lastModifiedDates = getLastModifiedDates($rootDir);

$values = array_values($lastModifiedDates);
array_multisort($values, SORT_DESC, $lastModifiedDates);


echo "\n";
// 결과 출력
foreach ($lastModifiedDates as $dir => $date) {
	printf("%-50s %s - %s\n", $dir, $date, $lastFile[$dir]);
}
?>
