<?php

namespace platyFramework;

//require_once("./db.php");
//require_once("./Elastic.php");
//require_once("./ptyCliLog.php");

ini_set('memory_limit', '2G');
ini_set('max_execution_time', '0');
set_time_limit(0);


require_once(__DIR__ . "/../elastic/Elastic.php");

class SomeEmbeddingCategoryItemsModel extends ptyItemsModel
{
    public $apiKey;
    public $aiModel;
    public $sourceTableName;

    public $_tableName = "t_category_items";
    public $_itemModel = "platyFramework\\ptyItemModel";

    /** @var x_DBConnector */
    // protected $db;

    /** @var Elastic */
    private $elastic;

    /** @var ptyCliLog */
    protected $cliLog;


    /*
    public function __construct($db, $tableName, $vectorTableName, Elastic $elastic, $cliLog)
    {
        define('PLATYFRAMEWORK_DB_CHARSET', 'utf8mb4');
        define('PLATYFRAMEWORK_DB_COLLATE', 'utf8mb4_unicode_ci');

        date_default_timezone_set('Asia/Seoul');
        $this->cliLog = $cliLog;

        $this->vectorTableName = $vectorTableName;

        $this->_tableName = $tableName;
        $this->indexName = $vectorTableName; // "ai_vector_embedding_" . $tableName;
        $this->db = $db;
        $this->db->connect();
        $this->cliLog->mysql("디비 연결됨");

        $this->elastic = $elastic;
        $this->_migrate();
        $this->buildElasticIndex();
    }
    */

    static public function buildModel(string $sourceTableName)
    {
        $model = new static (tableName: $sourceTableName . "_category");
        $model->sourceTableName = $sourceTableName;
        return $model;
    }


    function _migrate()
    {
        if (!$this->db->sql_result("SHOW TABLES LIKE '$this->_tableName'")) {
            $this->db->sql_query("
			CREATE TABLE IF NOT EXISTS `{$this->_tableName}` (
			`id` int(11) NOT NULL AUTO_INCREMENT,
			`descId` int(11) NULL DEFAULT 0,
			`enabled` tinyint(1) NOT NULL DEFAULT '1',
			`regDateTime` datetime NULL,

			`ip` varchar(64) NULL,
			`serviceUserId` varchar(64) NOT NULL,
			`userId` varchar(64) NOT NULL,
			
            `serviceName` varchar(64) null default '',
            `serviceId` varchar(64) null default '',
            `title` varchar(256) NULL default '' comment '제목',
			    
            `sourceText` MEDIUMTEXT NULL comment 'category를 생성할 때 사용된 원본 텍스트',
			    
            `aiModel` varchar(64) null default '' comment '사용된 AI 모델',
            `categoryType` varchar(64) null default '' comment '카테고리 생성시의 type. 예) 대, 중 분류로만 작업 OR 전체 분류로 작업 등',
			    
            `category1` varchar(64) null default '',
            `category2` varchar(64) null default '',
            `category3` varchar(64) null default '',
            `category4` varchar(64) null default '',
            `category5` varchar(64) null default '',
			    
            `inputTokens` int(11) null default 0 comment '입력 토큰 수',
            `outputTokens`  int(11) null default 0 comment '출력 토큰 수',
			    
			PRIMARY KEY (`id`),
            INDEX `idx_enabled` (`enabled`),
            INDEX `idx_serviceName` (`serviceName`),
            INDEX `idx_serviceId` (`serviceId`),
			    
            INDEX `idx_aiModel` (`aiModel`),
            INDEX `idx_categoryType` (`categoryType`),
			    
            INDEX `idx_category1` (`category1`),
            INDEX `idx_category2` (`category2`),
            INDEX `idx_category3` (`category3`),
            INDEX `idx_category4` (`category4`),
            INDEX `idx_category5` (`category5`),
            INDEX `idx_title` (`title`(20)),
            INDEX `idx_sourceText` (`sourceText`(5))
			) ENGINE=InnoDB DEFAULT CHARSET=" . PLATYFRAMEWORK_DB_CHARSET . " COLLATE=" . PLATYFRAMEWORK_DB_COLLATE . " AUTO_INCREMENT=1;
		");
        }
        // $this->cliLog->mysql("{$this->_tableName} 의 AI 테이블 마이그레이션 체크 완료");
    }

    public function setAPIKey($token)
    {
        $this->apiKey = $token;

    }

    public function setAIModel(string $string)
    {
        $this->aiModel = $string;

    }

    /**
     * OpenAI API 응답에서 카테고리와 토큰 정보를 추출
     *
     * @param array $result OpenAI API 응답 배열
     * @return array 파싱된 카테고리 및 토큰 정보
     * @throws \Exception JSON 파싱 실패 시
     */
    public function parseAIResponse($result)
    {
        // 1. content에서 JSON 블록 추출
        $content = $result['choices'][0]['message']['content'] ?? '';

        // ```json ... ``` 형태에서 JSON 부분만 추출
        if (preg_match('/```json\s*\n(.*?)\n```/s', $content, $matches)) {
            $jsonString = $matches[1];
        } else {
            // ```json이 없는 경우 전체 content를 JSON으로 시도
            $jsonString = $content;
        }

        // 2. JSON 파싱
        $categories = json_decode($jsonString, true);

        if (json_last_error() !== JSON_ERROR_NONE) {
            throw new \Exception("JSON 파싱 실패: " . json_last_error_msg() . ", content = $content");
        }

        // 3. 카테고리 추출 (category1 ~ category5)
        $category1 = $categories['category1'] ?? '';
        $category2 = $categories['category2'] ?? '';
        $category3 = $categories['category3'] ?? '';
        $category4 = $categories['category4'] ?? '';
        $category5 = $categories['category5'] ?? '';

        // 4. 토큰 정보 추출
        $promptTokens = $result['usage']['prompt_tokens'] ?? 0;
        $completionTokens = $result['usage']['completion_tokens'] ?? 0;
        $totalTokens = $result['usage']['total_tokens'] ?? 0;

        // 5. 결과 반환
        return [
            'category1' => $category1,
            'category2' => $category2,
            'category3' => $category3,
            'category4' => $category4,
            'category5' => $category5,
            'prompt_tokens' => $promptTokens,
            'completion_tokens' => $completionTokens,
            'total_tokens' => $totalTokens,
            'raw_categories' => $categories, // 전체 카테고리 데이터
            'raw_content' => $content, // 원본 content
        ];
    }

    /**
     * 법률 카테고리를 AI로 분류합니다.
     *
     * @param string $serviceName 서비스명 (예: "law")
     * @param string $serviceId 서비스 ID (예: "법령ID_순번ID")
     * @param string $type 분류 타입 (예: "depth1~2" - 대/중분류만 작업)
     * @param string $text 분류할 법률 텍스트
     *
     * _return ptyArrayItemModel 다음 프로퍼티를 포함하는 객체:
     *   - category1: 1차 대분류 (예: "민사법", "형사법", "행정법" 등)
     *   - category2: 2차 중분류 (예: "민법_총칙", "형법_총론", "행정조직법" 등)
     *   - category3: 3차 소분류 (예: "권리주체", "법률행위" 등)
     *   - category4: 4차 세분류 (예: "자연인의 권리능력" 등)
     *   - prompt_tokens: AI 호출 시 사용된 프롬프트 토큰 수
     *   - completion_tokens: AI가 생성한 응답의 토큰 수
     *
     * @psalm-return object{category1: string, category2: string, category3: string, category4: string, prompt_tokens: int, completion_tokens: int}
     * @phpstan-return object{category1: string, category2: string, category3: string, category4: string, prompt_tokens: int, completion_tokens: int}
     */
    public function buildLawCategory(string $serviceName, string $serviceId, string $title, string $text)
    {
        // 기존 카테고리 데이터 삭제 후 재삽입
        $this->db->sql_query("delete from {$this->_tableName} where serviceName = " . mrea($serviceName) . " and serviceId = " . mrea($serviceId));

        $types = ["depth1~2", "depth1~4"];

        foreach ($types as $type) {
            if ($type == "depth1~2") {
                $prompt = <<<END
# 01. 헌법
# 02. 민사법  
## 2-1. 민법_총칙  
## 2-2. 민법_물권  
## 2-3. 민법_채권  
## 2-4. 민법_친족  
## 2-5. 민법_상속  
## 2-6. 상법_총칙  
## 2-7. 상법_회사  
## 2-8. 상법_보험  
## 2-9. 상법_해상  
## 2-10. 민사소송법  
## 2-11. 민사집행법  
## 2-12. 도산법  

# 03. 형사법  
## 3-1. 형법_총론  
## 3-2. 형법_각론  
## 3-3. 형사소송법  
## 3-4. 특별형사법  
## 3-5. 보안처분  
## 3-6. 소년법  

# 04. 행정법  
## 4-1. 행정조직법  
## 4-2. 행정작용법  
## 4-3. 행정절차법  
## 4-4. 행정구제법  
## 4-5. 공무원법  
## 4-6. 지방자치법  
## 4-7. 부패방지·공익신고법  

# 05. 경제법  
## 5-1. 공정거래법  
## 5-2. 금융법  
## 5-3. 조세법  
## 5-4. 산업법  
## 5-5. 무역법  

# 06. 사회법  
## 6-1. 노동기본권법  
## 6-2. 노사관계법  
## 6-3. 고용정책법  
## 6-4. 사회보험법  
## 6-5. 공공부조법  
## 6-6. 보건의료법  
## 6-7. 교육법  
## 6-8. 가족·젠더폭력 보호법  

# 07. 국제법  
## 7-1. 국제공법  
## 7-2. 국제사법  
## 7-3. 국제거래법  
## 7-4. 출입국·이민·난민법  

# 08. 환경법  
## 8-1. 환경보전법  
## 8-2. 대기환경법  
## 8-3. 수질환경법  
## 8-4. 토양·지하수법  
## 8-5. 폐기물관리법  
## 8-6. 유해화학물질법  
## 8-7. 자연보호법  
## 8-8. 해양환경법  
## 8-9. 기후변화대응법  

# 09. 정보통신법  
## 9-1. 정보보호법  
## 9-2. 개인정보보호법  
## 9-3. 전자상거래법  
## 9-4. 통신법  
## 9-5. 콘텐츠법  

# 10. 지적재산권법  
## 10-1. 특허법  
## 10-2. 실용신안법  
## 10-3. 상표법  
## 10-4. 디자인보호법  
## 10-5. 저작권법  
## 10-6. 부정경쟁방지법  

# 11. 부동산법  
## 11-1. 부동산등기법  
## 11-2. 토지법  
## 11-3. 주택법  
## 11-4. 재개발·재건축법  
## 11-5. 건축법  
## 11-6. 농지·농어촌법  

# 12. 국방법  
## 12-1. 국방기본법  
## 12-2. 병역법  
## 12-3. 군인법  
## 12-4. 군형법 및 군사법원법  
## 12-5. 방위사업법  

# 13. 안전법  
## 13-1. 재난안전법  
## 13-2. 소방법  
## 13-3. 식품안전법  
## 13-4. 제품안전법  
## 13-5. 교통안전법  
## 13-6. 시설물안전법  
## 13-7. 산업안전법  
## 13-8. 원자력안전법  
## 13-9. 감염병안전법  
## 13-10. 생활안전법  

# 14. 선거·정치자금법  
## 14-1. 공직선거법  
## 14-2. 정치자금의 범위  
## 14-3. 정당법  
## 기타

위 카테고리를 이용하여 아래 질문에 대해 법률 카테고리를 category1, category2, category3, category4 를 반드시 구분하여 json 으로 한개를 리턴해줘
- 카테고리명은 "정당법" 처럼 숫자를 포함하지 않고 리턴한다.
- category1, category2, category3, category4 는 배열이 아닌 문자열로 리턴한다.
- category1, category2 는 항상 값이 입력되어야 한다.
- category3, category4 는 값을 예측하며, 값이 없을 경우 "기타" 로 처리한다.
예시)
```json
{
"category1": "민사법",
"category2": "민법_총칙",
"category3": "권리주체",
"category4": "자연인의 권리능력",
}
```

질문:
```
END;
            }

            if ($type == "depth1~4") {
                $prompt = <<<END
# 01. 헌법
# 02. 민사법
## 2-1. 민법_총칙
- 권리주체
  - 자연인의 권리능력
  - 자연인의 행위능력
  - 성년후견, 한정후견, 특정후견
  - 실종선고
  - 동시사망추정
- 법인
  - 법인의 설립
  - 법인의 능력
  - 법인의 기관
  - 법인의 정관변경
  - 법인의 해산 및 청산
  - 비영리법인
  - 영리법인
- 물건
  - 부동산과 동산
  - 주물과 종물
  - 원물과 과실
- 법률행위
  - 의사표시
  - 대리
  - 무효와 취소
  - 조건과 기한
- 기간
  - 기간의 계산
- 소멸시효
  - 소멸시효의 완성
  - 소멸시효의 중단
  - 소멸시효의 정지
  
## 2-2. 민법_물권
- 점유권
  - 점유의 취득
  - 점유의 효력
  - 점유의 소멸
  - 점유권의 보호
- 소유권
  - 소유권의 한계
  - 소유권의 취득
  - 공동소유 (공유, 합유, 총유)
  - 소유권에 기한 물권적 청구권
- 용익물권
  - 지상권
  - 지역권
  - 전세권
- 담보물권
  - 유치권
  - 질권 (동산질권, 권리질권)
  - 저당권
  - 근저당권
  - 가등기담보
- 부동산등기
  - 등기의 효력
  - 등기절차
  
## 2-3. 민법_채권
- 채권총칙
  - 채권의 목적
  - 채권의 효력
  - 수령지체
  - 채권자대위권
  - 채권자취소권
  - 다수당사자의 채권관계 (분할채권, 불가분채권, 연대채무, 보증채무)
  - 채권양도
  - 채무인수
- 계약총칙
  - 계약의 성립
  - 계약의 효력
  - 동시이행항변권
  - 위험부담
  - 제3자를 위한 계약
  - 계약해제
  - 계약해지
- 매매
  - 매매의 효력
  - 담보책임
  - 특수한 매매 (환매, 매도인의 담보책임)
- 교환, 소비대차, 사용대차
- 임대차
  - 임대차의 효력
  - 임대차의 종료
  - 주택임대차
  - 상가건물임대차
- 고용
- 도급
  - 도급의 효력
  - 수급인의 담보책임
  - 하도급
- 현상광고
- 위임
  - 위임의 효력
  - 위임의 종료
- 임치
- 조합
- 종신정기금
- 화해
- 사무관리
- 부당이득
  - 비채변제
  - 불법원인급여
- 불법행위
  - 일반불법행위
  - 특수불법행위 (사용자책임, 공작물책임, 공동불법행위)
  - 손해배상의 범위
  - 과실상계
  
## 2-4. 민법_친족
- 혼인
  - 혼인의 성립
  - 혼인의 무효와 취소
  - 혼인의 효력
  - 이혼 (협의이혼, 재판상이혼)
  - 재산분할
  - 위자료
- 친자
  - 친생자
  - 양자 (일반양자, 친양자)
  - 친권
  - 친생자관계부존재확인
  - 인지
- 후견
  - 미성년자의 후견
  - 성년후견, 한정후견, 특정후견
- 친족관계
  - 부양의무
  - 친족회

## 2-5. 민법_상속
- 상속
  - 상속의 개시
  - 상속인
  - 상속의 승인과 포기
  - 재산분리
  - 상속회복청구권
  - 공동상속
  - 상속분
  - 유산분할
- 유언
  - 유언의 방식
  - 유언의 효력
  - 유언의 철회
  - 유증
  - 유언집행자
- 유류분
  - 유류분의 산정
  - 유류분반환청구권
  
## 2-6. 상법_총칙
- 상인
  - 고유상인
  - 의제상인
  - 소상인
- 상행위
  - 상행위의 대리와 위임
  - 익명조합
- 상업사용인
- 상업장부
- 상호
- 상업등기
 
## 2-7. 상법_회사
- 합명회사
  - 설립
  - 사원의 권리의무
  - 해산
- 합자회사
- 유한책임회사
- 주식회사
  - 설립 (발기설립, 모집설립)
  - 주식 (보통주, 우선주, 종류주식)
  - 주식의 양도
  - 자기주식 취득
  - 주주총회 (소집, 결의방법, 의결권)
  - 이사 및 이사회
  - 대표이사
  - 감사 및 감사위원회
  - 회계
  - 자본금의 증감
  - 사채
  - 정관변경
  - 해산 및 청산
  - 합병, 분할
  - 주주의 권리 (소수주주권)
- 외국회사

## 2-8. 상법_보험
- 보험계약 총칙
  - 보험계약의 성립
  - 고지의무
  - 보험료
  - 보험계약의 무효와 실효
- 손해보험
  - 화재보험
  - 운송보험
  - 해상보험
  - 책임보험
- 인보험
  - 생명보험
  - 상해보험
  
## 2-9. 상법_해상
- 선박
  - 선박소유자
  - 선박공유
  - 선박임대차
  - 선박저당권
- 운송
  - 물건운송
  - 여객운송
  - 선하증권
- 해상보험
- 해난구조
- 공동해손

## 2-10. 민사소송법
- 소송요건
  - 당사자능력
  - 당사자적격
  - 소의 이익
- 소의 제기
  - 소장
  - 소송물
- 당사자
  - 소송능력
  - 법정대리
  - 소송대리인
  - 보조참가
  - 공동소송
- 심리
  - 변론주의
  - 직권주의
  - 공격방어방법
- 증거
  - 증거조사
  - 자유심증주의
  - 증명책임
  - 증인신문
  - 감정
  - 서증
- 판결
  - 판결의 확정
  - 기판력
  - 집행력
  - 형성력
- 상소
  - 항소
  - 상고
- 재심
- 독촉절차
- 소액사건

## 2-11. 민사집행법
- 강제집행
  - 금전집행 (부동산, 동산, 채권)
  - 인도집행
  - 대체집행
  - 간접강제
- 보전처분
  - 가압류
  - 가처분
- 경매
  - 부동산 경매
  - 배당
- 담보권실행

## 2-12. 도산법
- 파산
  - 파산신청
  - 파산선고
  - 파산관재인
  - 파산채권
  - 부인권
  - 배당
  - 면책
- 회생
  - 회생절차 개시
  - 관리인
  - 회생계획
  - 회생계획 인가
- 개인회생
  - 개인회생 절차
  - 변제계획


# 03. 형사법
## 3-1. 형법_총론
- 죄형법정주의
  - 관습형법금지
  - 소급효금지
  - 명확성원칙
  - 유추해석금지
- 형법의 적용범위
  - 시간적 적용범위
  - 장소적 적용범위
- 범죄론
  - 구성요건해당성
  - 위법성 (정당방위, 긴급피난, 자구행위, 피해자승낙)
  - 책임 (책임능력, 위법성인식, 기대가능성)
  - 미수범
  - 중지미수
  - 불능미수
  - 예비, 음모
  - 공범 (공동정범, 교사범, 종범, 간접정범)
  - 죄수론 (일죄, 수죄, 상상적경합, 실체적경합)
- 형벌론
  - 형의 종류
  - 형의 양정
  - 누범
  - 집행유예
  - 선고유예
  - 가석방
  - 형의 시효
  - 형의 소멸
- 보안처분

## 3-2. 형법_각론
- 생명·신체에 대한 죄
  - 살인죄
  - 상해죄
  - 과실치사상죄
  - 낙태죄
  - 유기죄
- 자유에 대한 죄
  - 협박죄
  - 강요죄
  - 체포·감금죄
  - 약취·유인죄
- 명예와 신용에 대한 죄
  - 명예훼손죄
  - 모욕죄
  - 신용훼손죄
  - 업무방해죄
- 사생활의 평온에 대한 죄
  - 비밀침해죄
  - 주거침입죄
- 재산에 대한 죄
  - 절도죄
  - 강도죄
  - 사기죄
  - 공갈죄
  - 횡령죄
  - 배임죄
  - 장물죄
  - 손괴죄
- 사회적 법익에 대한 죄
  - 공안을 해하는 죄
  - 폭발물에 관한 죄
  - 방화와 실화의 죄
  - 일수와 수리에 관한 죄
  - 교통방해의 죄
  - 음용수에 관한 죄
  - 아편에 관한 죄
  - 통화에 관한 죄
  - 유가증권·인지·우표에 관한 죄
  - 문서에 관한 죄
  - 인장에 관한 죄
  - 성풍속에 관한 죄
- 국가적 법익에 대한 죄
  - 내란의 죄
  - 외환의 죄
  - 국기에 관한 죄
  - 국교에 관한 죄
  - 공무원의 직무에 관한 죄
  - 공무방해에 관한 죄
  - 도주와 범인은닉의 죄
  - 위증과 증거인멸의 죄
  - 무고의 죄
  
## 3-3. 형사소송법
- 수사
  - 수사의 개시
  - 임의수사와 강제수사
  - 피의자신문
  - 체포 (긴급체포, 현행범체포, 통상체포)
  - 구속 (구속영장, 구속적부심사)
  - 압수·수색·검증
  - 통신제한조치
  - 고소·고발
- 공소
  - 공소제기
  - 공소시효
  - 공소취소
  - 기소독점주의
  - 기소편의주의
- 공판
  - 공판절차
  - 공판중심주의
  - 당사자주의
  - 공판준비
  - 피고인의 권리
  - 변호인
- 증거
  - 증거능력
  - 증명력
  - 자백배제법칙
  - 위법수집증거배제법칙
  - 전문법칙
  - 증인신문
- 재판
  - 판결의 선고
  - 유죄판결
  - 무죄판결
  - 면소판결
  - 공소기각판결
- 상소
  - 항소
  - 상고
  - 항고
- 재심
- 비상구제절차
- 약식절차
- 즉결심판
- 형의 집행

## 3-4. 특별형사법
- 성폭력범죄의 처벌 등에 관한 특례법
  - 성폭력범죄
  - 친족관계에 의한 가중처벌
  - 장애인에 대한 간음
  - 카메라등이용촬영
- 아동·청소년의 성보호에 관한 법률
  - 아동·청소년대상 성범죄
  - 아동·청소년 의제강간
  - 아동음란물
- 교통사고처리특례법
  - 교통사고처리
  - 종합보험등 가입자에 대한 특례
- 특정범죄가중처벌등에관한법률
  - 보복범죄
  - 상습범
  - 조직폭력
- 특정경제범죄가중처벌등에관한법률
  - 특정재산범죄
  - 배임·횡령 가중처벌
- 마약류관리에관한법률
  - 마약류 투약·소지
  - 마약류 제조·판매
- 폭력행위등처벌에관한법률
  - 집단·흉기 폭행
  - 상습폭행
  
## 3-5. 보안처분
- 치료감호
- 보호관찰
- 사회봉사명령
- 수강명령
- 전자장치 부착

## 3-6. 소년법
- 소년보호사건
  - 보호처분
  - 소년분류심사원
- 소년형사사건
  - 형사미성년자
  - 촉법소년
  

# 04. 행정법  
## 4-1. 행정조직법
- 중앙행정조직
  - 행정청
  - 행정관청
  - 보조기관
  - 자문기관
  - 의결기관
- 지방자치단체
  - 광역자치단체
  - 기초자치단체
  - 특별지방자치단체
- 공공기관
  - 공기업
  - 준정부기관
  - 기타공공기관
  
## 4-2. 행정작용법
- 행정행위
  - 행정행위의 종류 (명령적 행위, 형성적 행위, 준법률행위적 행정행위)
  - 행정행위의 부관 (조건, 기한, 부담, 철회권의 유보)
  - 행정행위의 하자 (무효와 취소)
  - 행정행위의 취소와 철회
  - 행정행위의 실효
- 행정입법
  - 법규명령 (대통령령, 총리령, 부령)
  - 행정규칙
  - 자치법규
- 행정계획
- 행정계약
- 행정지도
- 행정상 즉시강제
- 행정조사
- 행정벌
  - 행정형벌
  - 행정질서벌 (과태료)
- 행정강제
  - 행정대집행
  - 이행강제금
  - 직접강제
  - 강제징수
  
## 4-3. 행정절차법
- 처분절차
  - 신청
  - 의견청취
  - 이유제시
  - 처분의 통지
- 신고
- 행정예고
- 행정상 입법예고
- 청문
- 공청회
- 정보공개
  - 정보공개청구권
  - 비공개대상정보
  
## 4-4. 행정구제법
- 행정심판
  - 취소심판
  - 무효등확인심판
  - 의무이행심판
  - 행정심판위원회
  - 재결
- 행정소송
  - 항고소송 (취소소송, 무효등확인소송, 부작위위법확인소송)
  - 당사자소송
  - 민중소송
  - 기관소송
  - 소의 제기
  - 제소기간
  - 집행정지
  - 사정판결
- 국가배상
  - 공무원의 직무상 불법행위
  - 영조물의 설치·관리 하자
- 손실보상
  - 적법한 공권력 행사로 인한 재산권 침해
  - 생활보상
  
## 4-5. 공무원법
- 공무원의 종류
  - 경력직 공무원
  - 특수경력직 공무원
- 임용
  - 신규채용
  - 승진
  - 전보
  - 겸임
- 복무
  - 성실의무
  - 복종의무
  - 직장이탈금지
  - 비밀엄수의무
  - 청렴의무
  - 품위유지의무
  - 정치운동금지
- 신분보장
- 징계
  - 징계사유
  - 징계종류 (파면, 해임, 강등, 정직, 감봉, 견책)
  - 징계절차
- 소청
- 연금
  - 퇴직급여
  - 유족급여
  - 장해급여
  
## 4-6. 지방자치법
- 자치조직
  - 지방의회
  - 집행기관 (지방자치단체장)
- 자치재정
  - 지방세
  - 지방교부세
  - 지방채
- 주민참여
  - 주민투표
  - 주민소환
  - 주민감사청구
  - 주민소송
- 조례
  - 조례제정권의 범위
  - 조례와 법률의 관계
  
## 4-7. 부패방지·공익신고법  
- 부패행위
  - 공직자 부패
  - 계약·입찰 비리
  - 금품·향응 수수

- 부패방지 제도
  - 기본원칙
  - 종합계획
  - 권익위 권한

- 공익신고 제도
  - 공익침해행위 범위
  - 신고방법(서면·전화·온라인)
  - 내부·외부 신고

- 공익신고자 보호
  - 신분보장
  - 불이익 금지
  - 비밀보장
  - 원상회복

- 보상·포상
  - 보상금
  - 포상금
  - 산정 기준

- 이해충돌방지
  - 사적 이해관계 신고
  - 가족채용 제한
  - 수의계약 제한
  - 금품 수수 제한

- 조사·제재
  - 조사 절차
  - 시정권고
  - 의견표명
  - 형사처벌·과태료
  
# 05. 경제법  
## 5-1. 공정거래법
- 독점규제
  - 시장지배적지위 남용금지
  - 경쟁제한적 기업결합 제한
  - 부당한 공동행위 금지
- 불공정거래행위
  - 거래거절
  - 차별적 취급
  - 경쟁사업자 배제
  - 부당염매
  - 끼워팔기
  - 거래상 지위 남용
  - 구속조건부 거래
- 재판매가격유지행위
- 기업결합
  - 신고의무
  - 심사기준
- 소비자보호
  - 표시·광고의 공정화
  - 약관규제
- 하도급거래 공정화
  - 하도급대금 지급
  - 부당한 하도급대금 결정금지
  - 부당특약 금지
  
## 5-2. 금융법
- 은행법
  - 은행업 인가
  - 은행의 업무
  - 건전경영
  - 대주주 적격성
- 자본시장법
  - 증권의 발행·공시
  - 불공정거래 (내부자거래, 시세조종, 부정거래)
  - 투자매매업·투자중개업
  - 집합투자
  - 신탁업
- 보험업법
  - 보험업 허가
  - 보험상품 인가·신고
  - 모집질서
  - 보험계약자 보호
- 여신전문금융업법
  - 신용카드업
  - 시설대여업
  - 할부금융업
- 상호저축은행법
- 금융지주회사법
- 외국환거래법
  - 지급등
  - 자본거래
  - 외환건전성
  
## 5-3. 조세법
- 국세기본법
  - 납세의무
  - 과세요건
  - 국세와 일반채권
  - 국세환급금
  - 과세전적부심사
  - 이의신청
  - 심사청구
  - 심판청구
- 소득세법
  - 이자소득
  - 배당소득
  - 사업소득
  - 근로소득
  - 연금소득
  - 기타소득
  - 종합소득과세표준
  - 세액공제
- 법인세법
  - 각사업연도소득
  - 익금과 손금
  - 손익의 귀속시기
  - 접대비·기부금
  - 세액공제·감면
- 부가가치세법
  - 과세거래
  - 영세율과 면세
  - 매출세액과 매입세액
  - 납부세액과 환급세액
- 상속세 및 증여세법
  - 상속세 과세가액
  - 증여세 과세가액
  - 증여재산 공제
  - 재산평가
- 종합부동산세법
- 지방세법
  - 취득세
  - 재산세
  - 자동차세
  - 지방소득세
- 관세법
  - 과세가격
  - 관세율
  - 통관
  - 보세구역
  
## 5-4. 산업법
- 중소기업기본법
  - 중소기업의 범위
  - 중소기업 지원
- 벤처기업육성에관한특별조치법
  - 벤처기업 확인
  - 벤처투자
- 산업발전법
- 에너지법
  - 전기사업법
  - 석유 및 석유대체연료 사업법
  - 도시가스사업법
  
## 5-5. 무역법
- 대외무역법
  - 수출입
  - 원산지표시
  - 불공정무역행위
- 외국인투자촉진법
  - 외국인투자 신고
  - 외국인투자기업
- 통관법 (관세법)

# 06. 사회법  
## 6-1. 노동기본권법
- 근로기준법
  - 근로계약
    - 근로계약 체결
    - 근로계약 기간
    - 근로조건 명시
    - 근로계약 해지
  - 임금
    - 임금지급원칙
    - 최저임금
    - 평균임금
    - 통상임금
    - 임금채권 우선변제
    - 체불임금
  - 근로시간
    - 법정근로시간
    - 연장근로
    - 야간근로·휴일근로
    - 탄력적 근로시간제
    - 선택적 근로시간제
  - 휴게·휴일
    - 휴게시간
    - 주휴일
    - 연차유급휴가
  - 여성과 소년
    - 임산부 보호
    - 육아시간
    - 야간·휴일근로 제한
  - 해고 등
    - 정당한 이유
    - 해고예고
    - 부당해고 구제
  - 퇴직급여
    - 퇴직금
    - 퇴직연금
  - 근로감독
- 산업재해보상보험법
  - 업무상 재해
  - 요양급여
  - 휴업급여
  - 장해급여
  - 유족급여
  - 산재보험료
  
## 6-2. 노사관계법
- 노동조합및노동관계조정법
  - 노동조합
    - 노동조합 설립
    - 조합원 자격
    - 노동조합 활동
    - 부당노동행위
  - 단체교섭
    - 교섭대표노동조합
    - 성실교섭의무
  - 단체협약
    - 단체협약의 효력
    - 일반적 구속력
  - 쟁의행위
    - 쟁의행위의 정당성
    - 쟁의행위 제한
    - 직장폐쇄
  - 노동쟁의 조정
    - 알선
    - 조정
    - 중재
  - 부당노동행위 구제
- 노동위원회법
- 교원의노동조합설립및운영등에관한법률
- 공무원의노동조합설립및운영등에관한법률

## 6-3. 고용정책법
- 고용정책기본법
- 고용촉진
  - 고용상 연령차별금지
  - 장애인고용촉진
  - 외국인근로자 고용
- 직업안정법
  - 직업소개
  - 근로자공급사업
  - 근로자파견
- 직업능력개발법
- 고용보험법
  - 고용안정·직업능력개발사업
  - 실업급여
    - 구직급여
    - 취업촉진수당
  - 육아휴직 급여
  - 출산전후휴가 급여
  
## 6-4. 사회보험법
- 국민연금법
  - 가입자
  - 연금보험료
  - 노령연금
  - 장애연금
  - 유족연금
  - 반환일시금
- 국민건강보험법
  - 가입자·피부양자
  - 보험료
  - 요양급여
  - 본인부담금
  - 건강검진
- 노인장기요양보험법
  - 장기요양인정
  - 장기요양급여
- 장기요양기관
- 산업재해보상보험법 (재게시)

## 6-5. 공공부조법
- 국민기초생활보장법
  - 수급권자
  - 생계급여
  - 의료급여
  - 주거급여
  - 교육급여
  - 자활급여
  - 부양의무자
- 의료급여법
- 긴급복지지원법
- 기초연금법
- 장애인연금법

## 6-6. 보건의료법
- 의료법
  - 의료인 (의사, 치과의사, 한의사, 조산사, 간호사)
  - 의료기관
  - 의료행위
  - 무면허의료행위
  - 의료광고
  - 진료기록부
- 약사법
  - 약사·한약사
  - 의약품 제조·판매
  - 처방전
  - 조제
- 감염병의예방및관리에관한법률
  - 감염병의 분류
  - 감염병 예방·관리
  - 예방접종
  - 역학조사
  - 격리·입원치료
- 국민건강증진법
  - 금연
  - 건강검진
- 응급의료에관한법률
- 혈액관리법
- 장기등이식에관한법률
- 정신건강증진및정신질환자복지서비스지원에관한법률

## 6-7. 교육법
- 교육기본법
- 초·중등교육법
  - 학교의 종류
  - 학생·학부모
  - 교원
  - 학교운영위원회
- 고등교육법
  - 대학의 종류
  - 입학·졸업
  - 학사관리
- 평생교육법
- 유아교육법
- 사립학교법
- 교원의지위향상및교육활동보호를위한특별법

## 6-8. 가족·젠더폭력 보호법
- 가정폭력 범죄 절차
  - 범죄 범위
  - 긴급임시조치
  - 임시조치
  - 보호처분

- 피해자 보호·지원
  - 보호시설(쉼터)
  - 의료·상담
  - 법률·주거지원

- 가정폭력방지법
  - 국가·지자체 책임
  - 보호계획
  - 가해자 교정·교육

- 스토킹·데이트폭력
  - 스토킹 범죄요건
  - 잠정조치
  - 접근금지·위치추적

- 성폭력 피해자 보호
  - 신변보호
  - 비공개 재판
  - 2차 피해 방지


# 07. 국제법  
## 7-1. 국제공법
- 조약법
  - 조약의 체결
  - 조약의 유보
  - 조약의 해석
  - 조약의 효력
  - 조약의 개정·수정
  - 조약의 종료·정지
- 국제기구법
  - 국제연합(UN)
  - 전문기구
  - 지역기구
- 국가책임법
  - 국제위법행위
  - 국가책임의 성립
  - 손해배상
- 외교관계법
  - 외교특권·면제
  - 영사관계
- 국제분쟁해결
  - 국제사법재판소
  - 중재재판
  - 조정·중개
- 국제인권법
  - 세계인권선언
  - 국제인권규약
  - 난민보호
- 국제인도법
  - 전쟁법
  - 제네바협약
- 해양법
  - 영해
  - 배타적경제수역
  - 대륙붕
  - 공해
- 항공우주법
- 국제환경법
  - 기후변화협약
  - 생물다양성협약
  
## 7-2. 국제사법
- 섭외사법 (국제사법)
  - 국제재판관할
  - 준거법
  - 외국판결의 승인·집행
- 인적 사항
  - 국적
  - 외국인의 지위
  - 혼인·이혼
  - 친자관계
  - 입양
  - 상속
- 물권
  - 부동산물권
  - 동산물권
- 채권
  - 계약
  - 불법행위
- 가사사건
  - 국제결혼
  - 국제이혼
  - 국제입양
  
## 7-3. 국제거래법
- 국제물품매매
  - CISG (UN 국제물품매매협약)
  - 인코텀즈 (Incoterms)
- 국제운송
  - 해상운송
  - 항공운송
  - 복합운송
- 국제결제
  - 신용장 (L/C)
  - 추심결제
  - 송금결제
- 국제중재
  - 국제상사중재
  - 중재판정의 승인·집행
  - 뉴욕협약
- 국제투자
  - 투자보장협정 (BIT)
  - 투자자-국가 분쟁해결 (ISD)
- WTO법
  - GATT
  - GATS
  - TRIPs
  - 분쟁해결절차
  
## 7-4. 출입국·이민·난민법  

- 출입국관리
  - 입국·출국 심사
  - 입국금지·상륙거부

- 체류자격·비자
  - 단기체류
  - 장기체류
  - 취업·유학·결혼이민
  - 체류기간 연장·변경

- 불법체류·강제퇴거
  - 체류기간 경과
  - 출국명령
  - 강제퇴거·송환
  - 보호실 수용

- 재외동포법
  - 재외동포의 범위
  - F-4 체류자격

- 난민법
  - 난민 정의
  - 난민인정 신청·심사
  - 인도적 체류
  - 난민인정 취소·철회

- 국적(연계 태그)
  - 귀화
  - 국적취득·상실
  - 국적회복

# 08. 환경법  
## 8-1. 환경보전법
- 환경정책기본법
  - 환경기준
  - 환경영향평가
  - 사전환경성검토
  - 환경오염피해 구제
- 환경영향평가법
  - 전략환경영향평가
  - 환경영향평가
  - 소규모환경영향평가
- 환경분쟁조정법
  - 환경분쟁조정위원회
  - 재정·조정·중재
- 환경오염피해배상책임및구제에관한법률
  - 무과실책임
  - 환경오염피해구제
  
## 8-2. 대기환경법
- 대기환경보전법
  - 대기오염물질 배출규제
  - 배출허용기준
  - 대기오염물질 총량관리
  - 자동차 배출가스 규제
  - 비산먼지 관리
- 실내공기질관리법
- 소음·진동관리법
  - 생활소음 규제
  - 공사장 소음
  - 교통소음
- 악취방지법

## 8-3. 수질환경법
- 물환경보전법
  - 수질오염물질 배출규제
  - 수질오염총량관리
  - 폐수처리
  - 공공수역 보호
- 하수도법
  - 공공하수도
  - 개인하수처리시설
- 물의재이용촉진및지원에관한법률
- 먹는물관리법
  - 먹는물 수질기준
  - 정수시설
  - 먹는샘물
  
## 8-4. 토양·지하수법
- 토양환경보전법
  - 토양오염물질
  - 토양오염 조사·정화
  - 토양보전대책지역
- 지하수법
  - 지하수 이용
  - 지하수 보전
- 가축분뇨의관리및이용에관한법률

## 8-5. 폐기물관리법
- 폐기물관리법
  - 폐기물의 분류 (생활폐기물, 사업장폐기물, 지정폐기물)
  - 폐기물 처리
  - 폐기물 수집·운반·처리업
  - 폐기물처리시설
  - 불법투기 단속
- 자원의절약과재활용촉진에관한법률
  - 재활용의무
  - 재활용산업
- 전기·전자제품및자동차의자원순환에관한법률
  - 재활용부담금
  - EPR (생산자책임재활용)
- 건설폐기물의재활용촉진에관한법률

## 8-6. 유해화학물질법
- 화학물질의등록및평가등에관한법률 (화평법)
  - 화학물질 등록
  - 화학물질 평가
  - 유해화학물질 지정
- 화학물질관리법 (화관법)
  - 유해화학물질 취급시설
  - 유해화학물질 영업허가
  - 장외영향평가
  - 위해관리계획서
- 잔류성유기오염물질관리법

## 8-7. 자연보호법
- 자연환경보전법
  - 생태·경관보전지역
  - 자연환경조사
  - 자연환경영향조사
  - 생태계 보전
- 야생생물보호및관리에관한법률
  - 멸종위기 야생생물
  - 야생동물 포획금지
  - 수렵
- 습지보전법
- 독도등도서지역의생태계보전에관한특별법
- 백두대간보호에관한법률
- 자연공원법
  - 국립공원
  - 도립공원
  - 군립공원

## 8-8. 해양환경법
- 해양환경관리법
  - 해양오염물질 배출규제
  - 해양환경기준
  - 선박 오염방지
- 해양생태계의보전및관리에관한법률
  - 해양보호구역
  - 해양생태계 보전
- 해양폐기물및해양오염퇴적물관리법

## 8-9. 기후변화대응법
- 탄소중립기본법 (기후위기대응을위한탄소중립·녹색성장기본법)
  - 온실가스 감축목표
  - 국가 탄소중립 녹색성장 기본계획
  - 배출권거래제
  - 기후변화영향평가
- 신에너지및재생에너지개발·이용·보급촉진법
  - 태양광
  - 풍력
  - 수소에너지
- 에너지이용합리화법
  - 에너지 효율
  - 에너지진단
  
# 09. 정보통신법

## 9-1. 정보보호법
- 정보통신망이용촉진및정보보호등에관한법률
  - 정보통신서비스 제공자의 의무
  - 정보보호 조치
  - 개인정보 보호 (본법 내)
  - 본인확인
  - 불법정보 유통금지
  - 명예훼손
  - 스팸 규제
  - 청소년 보호
- 정보보호산업의진흥에관한법률
- 정보통신기반보호법

## 9-2. 개인정보보호법
- 개인정보보호법
  - 개인정보의 수집·이용
  - 개인정보의 제공
  - 개인정보의 처리위탁
  - 개인정보의 파기
  - 개인정보 열람·정정·삭제
  - 개인정보 처리방침
  - 개인정보 보호책임자
  - 가명정보
  - 민감정보·고유식별정보
  - 개인정보 영향평가
  - 개인정보 침해 신고·상담
  - 집단분쟁조정
  - 손해배상
- 신용정보의이용및보호에관한법률
  - 신용정보의 수집·조사
  - 신용정보의 제공·활용
  - 신용평가
  - 신용정보 관리·보호
- 위치정보의보호및이용등에관한법률
  - 위치정보사업
  - 위치정보의 수집·이용·제공

## 9-3. 전자상거래법
- 전자문서및전자거래기본법
  - 전자문서
  - 전자서명
  - 공인전자서명
  - 전자거래
- 전자서명법
  - 전자서명인증
  - 공동인증서
  - 민간인증서
- 전자상거래등에서의소비자보호에관한법률
  - 통신판매
  - 청약철회
  - 소비자 피해보상
  - 전자상거래분쟁조정위원회
- 방문판매등에관한법률
  - 다단계판매
  - 후원방문판매

## 9-4. 통신법
- 전기통신사업법
  - 전기통신사업 허가·등록
  - 전기통신역무 제공
  - 통신비밀
  - 망중립성
  - 상호접속
- 방송통신발전기본법
- 방송법
- 인터넷멀티미디어방송사업법
- 우편법

## 9-5. 콘텐츠법
- 콘텐츠산업진흥법
- 게임산업진흥에관한법률
  - 게임물 등급분류
  - 게임제공업
  - 사행성 규제
- 영화및비디오물의진흥에관한법률
- 음악산업진흥에관한법률

# 10. 지적재산권법

## 10-1. 특허법
- 특허요건
  - 발명의 성립성
  - 산업상 이용가능성
  - 신규성
  - 진보성
- 특허출원
  - 출원서류
  - 우선권
  - 출원공개
  - 분할출원·변경출원
- 특허심사
  - 심사청구
  - 거절이유통지
  - 의견서 제출
- 특허권
  - 특허권의 효력
  - 특허권의 존속기간
  - 특허권의 이전·등록
  - 통상실시권·전용실시권
  - 직무발명
- 특허침해
  - 침해금지청구
  - 손해배상청구
  - 침해로 보는 행위
- 특허무효·정정
  - 무효심판
  - 정정심판

## 10-2. 실용신안법
- 고안의 보호
- 실용신안등록

## 10-3. 상표법
- 상표등록요건
  - 식별력
  - 부등록사유
- 상표출원
  - 상표의 사용
  - 지정상품
- 상표권
  - 상표권의 효력
  - 상표권의 존속기간·갱신
  - 상표사용권
- 상표침해
- 상표등록취소·무효

## 10-4. 디자인보호법
- 디자인등록요건
  - 신규성
  - 창작비용이성
- 디자인권
  - 디자인권의 효력
  - 관련디자인

## 10-5. 저작권법
- 저작물
  - 저작물의 종류
  - 2차적 저작물
  - 편집저작물
  - 업무상 저작물
- 저작자
- 저작인격권
  - 공표권
  - 성명표시권
  - 동일성유지권
- 저작재산권
  - 복제권
  - 공연권
  - 공중송신권
  - 전시권
  - 배포권
  - 대여권
  - 2차적저작물작성권
- 저작재산권의 제한
  - 공정이용
  - 사적 이용
  - 인용
- 저작인접권
  - 실연자의 권리
  - 음반제작자의 권리
  - 방송사업자의 권리
- 저작권 침해
  - 침해금지·예방청구
  - 손해배상
  - 형사처벌
- 저작권 등록

## 10-6. 부정경쟁방지법
- 부정경쟁행위
  - 혼동행위
  - 저명상표 무단사용
  - 상품형태 모방
  - 영업비밀 침해
  - 도메인이름 부정취득
- 영업비밀
  - 영업비밀의 요건
  - 영업비밀 침해행위

# 11. 부동산법  

## 11-1. 부동산등기법
- 등기의 종류
  - 소유권보존등기
  - 소유권이전등기
  - 가등기
  - 경매·공매 등기
  - 담보권등기 (저당권, 근저당권, 전세권)
- 등기절차
  - 등기신청
  - 등기필정보·등기필증
  - 등기사항증명서
- 등기의 효력
  - 공신력
  - 추정력

## 11-2. 토지법
- 국토의계획및이용에관한법률
  - 도시·군관리계획
  - 용도지역·용도지구·용도구역
  - 개발행위허가
  - 지구단위계획
- 토지이용규제기본법
- 공간정보의구축및관리등에관한법률 (구 측량법)
- 부동산등기법
- 토지보상법 (공익사업을위한토지등의취득및보상에관한법률)
  - 사업인정
  - 토지조서·물건조서
  - 손실보상
  - 수용재결
  - 이의신청·행정소송

## 11-3. 주택법
- 주택법
  - 주택건설사업
  - 주택공급
  - 분양가상한제
  - 리모델링
- 주택임대차보호법
  - 대항력
  - 확정일자
  - 우선변제권
  - 계약갱신청구권
  - 전월세상한제
- 민간임대주택에관한특별법
- 장기공공임대주택입주자삶의질향상지원법
- 빈집및소규모주택정비에관한특례법

## 11-4. 재개발·재건축법
- 도시및주거환경정비법
  - 정비사업의 종류 (재개발, 재건축)
  - 정비구역 지정
  - 조합설립
  - 사업시행계획
  - 관리처분계획
  - 분양·입주
- 빈집및소규모주택정비에관한특례법
  - 가로주택정비사업
  - 소규모재건축사업

## 11-5. 건축법
- 건축법
  - 건축허가·신고
  - 용도변경
  - 건축기준 (건폐율, 용적률, 높이제한)
  - 건축선
  - 대지와 도로의 관계
  - 일조권
  - 사용승인
  - 건축물대장
  - 위반건축물
- 건축물의분양에관한법률
- 집합건물의소유및관리에관한법률
  - 구분소유
  - 공용부분
  - 관리단·관리인
  - 규약
  - 관리비


## 11-6. 농지·농어촌법
- 농지 소유·이용
  - 농지 정의
  - 농업인·농업법인 요건
  - 농지취득자격증명
  - 농지 임대·사용대차

- 농지전용
  - 전용허가
  - 협의 절차
  - 불법전용·원상회복

- 농어촌정비
  - 농업기반시설
  - 농어촌정비사업
  - 수용·보상

- 수산업·어업권
  - 어업면허
  - 어업허가
  - 양식업·구획어업
  - 공유수면 점·사용

- 수산자원 보호
  - 금어기
  - 금지체장
  - 보호수면
  - 불법어업 단속
  
# 12. 국방법  
## 12-1. 국방기본법
- 국방기본법
  - 국가안보
  - 국방목표
  - 국방정책
  - 국방조직
- 군사기밀보호법
- 국가정보원법

## 12-2. 병역법
- 병역법
  - 병역의무
  - 병역종류 (현역, 예비역, 보충역, 전시근로역)
  - 징병검사
  - 입영
  - 병역면제
  - 병역감면
  - 전환복무 (사회복무요원, 산업기능요원, 전문연구요원)
  - 병역처분
  - 병역기피
- 향토예비군설치법
- 민방위기본법

## 12-3. 군인법
- 군인사법
  - 임관
  - 진급
  - 보직
  - 전역
- 군인복무규율
- 군인연금법
  - 퇴역연금
  - 유족연금
  - 상이연금
- 군무원인사법

## 12-4. 군형법 및 군사법원법
- 군형법
  - 항명죄
  - 반란죄
  - 이탈죄
  - 초병근무태만
  - 군용물 관련 범죄
- 군사법원법
  - 군사법원의 조직
  - 군검찰
  - 군사재판 절차
  - 상소

## 12-5. 방위사업법
- 방위사업법
  - 방위력개선사업
  - 방산물자 조달
  - 방산업체 관리
- 방위산업기술보호법

# 13. 안전법  

## 13-1. 재난안전법
- 재난및안전관리기본법
  - 재난의 예방·대비·대응·복구
  - 국가안전관리기본계획
  - 안전관리계획
  - 재난선포
  - 특별재난지역 선포
  - 재난지원금
- 자연재해대책법
  - 풍수해
  - 지진
  - 설해
- 지진·화산재해대책법
- 급경사지재해예방에관한법률

## 13-2. 소방법
- 소방기본법
  - 소방조직
  - 소방활동
  - 화재조사
- 소방시설설치및관리에관한법률
  - 소화설비
  - 경보설비
  - 피난구조설비
  - 소화용수설비
  - 소방시설 점검
- 위험물안전관리법
  - 위험물의 종류
  - 제조소등의 설치·관리
- 다중이용업소의안전관리에관한특별법

## 13-3. 식품안전법
- 식품위생법
  - 식품제조·가공업
  - 식품첨가물
  - 유통기한
  - 식품위생검사
  - 영업허가·신고
  - 위해식품 회수
- 건강기능식품에관한법률
- 축산물위생관리법
- 식품안전기본법
- 수입식품안전관리특별법
- 어린이식생활안전관리특별법

## 13-4. 제품안전법
- 제품안전기본법
  - 제품안전 인증
  - 결함제품 리콜
- 전기용품및생활용품안전관리법
  - 안전인증
  - 안전확인
  - 공급자적합성확인
- 어린이제품안전특별법

## 13-5. 교통안전법
- 도로교통법
  - 운전면허
  - 교통신호
  - 통행방법
  - 주차·정차
  - 음주운전
  - 과속
  - 무면허운전
  - 교통사고
- 교통안전법
- 자동차관리법
  - 자동차 등록
  - 자동차 검사
- 여객자동차운수사업법
- 화물자동차운수사업법
- 철도안전법
- 항공안전법
- 선박안전법
- 해사안전법

## 13-6. 시설물안전법
- 시설물의안전및유지관리에관한특별법
  - 1종·2종·3종 시설물
  - 안전점검
  - 정밀안전진단
- 승강기안전관리법
- 어린이놀이시설안전관리법
- 댐안전관리및재해예방에관한법률

## 13-7. 산업안전법
- 산업안전보건법
  - 안전보건관리체계
  - 안전보건교육
  - 위험성평가
  - 중대재해 예방
  - 유해·위험작업
  - 보호구
  - 작업환경측정
  - 특수건강진단
- 중대재해처벌법
  - 중대산업재해
  - 중대시민재해
  - 경영책임자 처벌

## 13-8. 원자력안전법
- 원자력안전법
  - 원자력시설 안전규제
  - 방사선 안전관리
  - 방사성폐기물 관리
- 생활주변방사선안전관리법

## 13-9. 감염병안전법
- 감염병의예방및관리에관한법률
  - 감염병 분류 (1급~4급)
  - 감염병 감시
  - 역학조사
  - 격리·입원
  - 예방접종
  - 방역조치
- 검역법

## 13-10. 생활안전법
- 어린이안전관리에관한법률
  - 어린이보호구역
- 학교안전사고예방및보상에관한법률
- 다중이용시설등의실내공기질관리법
- 공중위생관리법
  - 숙박업
  - 목욕장업
  - 이용업·미용업
  
# 14. 선거·정치자금법  
## 14-1. 공직선거법
- 선거제도·선거권
  - 선거권·피선거권
  - 선거구·비례대표
- 후보자·등록
  - 후보자 등록 요건
  - 공천·추천 절차
- 선거운동
  - 선거운동 기간
  - 허용된 방식
  - 금지행위(비방·허위사실·금품 등)
- 선거비용
  - 제한액
  - 비용 보전
  - 회계보고
- 선거범죄
  - 허위사실공표
  - 매수·기부행위
  - 당선무효

## 14-2. 정치자금의 범위
- 정치자금의 범위
- 기부·기탁
  - 개인·법인 기부 제한
  - 후원회 제도
- 수입·지출 규제
  - 장부작성
  - 용도 제한
- 회계보고
  - 회계책임자
  - 공개·열람
- 위반행위
  - 불법자금
  - 허위 회계보고

## 14-3. 정당법
- 정당 설립·등록
- 당원
  - 자격·권리·의무
- 정당 운영
  - 중앙당·지방조직
  - 당헌·당규
- 정당활동
  - 국고보조금
- 정당해산
  - 위헌정당심판
  - 해산 효과

# 15. 기타
## 15-1. 기타
- 기타
  - 국가유공자·보훈
  - 국가유공자+복권방
  - 군형법·병역법
  - 출입국·비자
  - 의료사고
  - 환경·개발 인허가
  - 연예·엔터 계약
  - 학교폭력·학생징계
  - 공정거래·가맹·하도급
  - 변호사법·법률사무 알선

위 카테고리를 이용하여 아래 질문에 대해 법률 카테고리를 category1, category2, category3, category4 를 반드시 구분하여 json 으로 한개를 리턴해줘
- 카테고리명은 "정당법" 처럼 숫자를 포함하지 않고 리턴한다.
- category1, category2, category3, category4 는 배열이 아닌 문자열로 리턴한다.
- category1, category2 는 항상 값이 입력되어야 한다.
- category3, category4 는 값이 없을 경우 "기타" 로 처리한다.
예시)
```json
{
"category1": "민사법",
"category2": "민법_총칙",
"category3": "권리주체",
"category4": "자연인의 권리능력",
}
```

질문:
```
END;
            }

            if ($prompt == "") die ("prompt is empty");

            require_once("ptyLibrary_PHP/ai/chatgpt.api.common.model.php");
            $aiModel = ChatGPTAPIModel::build();
            $aiModel->setModel($this->aiModel);
            $aiModel->setAPIKey($this->apiKey);

            for ($i = 0; $i < 3; $i++) {
                $message = $prompt . "\n" . $text;
                $result = $aiModel->get($message);

                // json 파싱 시작
                echo "\n[$i] 파싱 시작. 제목 = " . $title . "\n";
                echo "[$i] type: {$type}\n";
                // echo "[$i] 파싱 시작. 텍스트 = " . $text . "\n";
                $parsed = $this->parseAIResponse($result);

                if (!is_array($parsed)) {
                    throw new \Exception("AI 파싱 처리 실패. result = $result");
                }

                print_r($parsed);
                echo "[$i] 카테고리1: {$parsed['category1']}\n";
                echo "[$i] 카테고리2: {$parsed['category2']}\n";
                echo "[$i] 카테고리3: {$parsed['category3']}\n";
                echo "[$i] 카테고리4: {$parsed['category4']}\n";
                echo "[$i] 프롬프트 토큰: {$parsed['prompt_tokens']}\n";
                echo "[$i] 완료 토큰: {$parsed['completion_tokens']}\n";

                // 대분류, 중분류가 없는 경우 에러
                if ($parsed['category1'] == "" || $parsed['category2'] == "")
                    throw new \Exception("카테고리가 비어 있음. result = $result");

                $item = ptyArrayItemModel::build();
                $item->category1 = trim($parsed['category1']);
                $item->category2 = trim($parsed['category2']);
                $item->category3 = trim($parsed['category3']);
                $item->category4 = trim($parsed['category4']);
                $item->inputTokens = $parsed['prompt_tokens'];
                $item->outputTokens = $parsed['completion_tokens'];
                $item->serviceName = $serviceName;
                $item->serviceId = $serviceId;
                $item->categoryType = $type;
                $item->sourceText = $text;
                $item->aiModel = $this->aiModel;
                $item->title = $title;

                // setpd(true);
                if ($this->getItemBy([
                    "serviceName" => $item->serviceName,
                    "serviceId" => $item->serviceId,
                    "category1" => $item->category1,
                    "category2" => $item->category2,
                    "category3" => $item->category3,
                    "category4" => $item->category4,
                ])) {
                    echo "이미 존재함.\n";
                    continue;
                }

                echo "카테고리 삽입됨.\n";
                // print_r($item->_item);
                $this->add($item);
            }
        }

        return $item;
    }
}

?>