<?php
/**
 * Created by PhpStorm.
 * User: cpueblo
 * Date: 2016. 8. 30.
 * Time: 오후 4:56
 */
namespace platyFramework;

class ptyDBListModel extends model
{
	public $_tableName;
	public $itemModelClassName;
	public $pageName;
	public $itemsPerPage;
	private $totalCount;

	function __construct($tableName, $itemModelClassName, $pageName = "page", $itemsPerPage = 0)
	{
		parent::__construct();

		$this->_tableName = $tableName;
		$this->itemModelClassName = $itemModelClassName;
		$this->pageName = $pageName;
		$this->itemsPerPage = $itemsPerPage;

		$this->init();
	}

	function init($enabled = true)
	{
		$this->db->clear();
		$this->db->addSelect("*");
		$this->db->addFrom($this->_tableName);

		if ($enabled)
			$this->db->addWhereEqual("enabled", "1");
		return $this;
	}

	function addWhereEnabled()
	{
		$this->db->addWhereEqual("enabled", "1");
		return $this;
	}
	
	function getItemBy($key, $value)
	{
		$this->db->addWhereEqual($key, $value);
		return $this->getItem();
	}
	
	function addWhere($values)
	{
		// $this->db->addWhere()
		// $this->db->addWhere($values);
		
	}

	function get()
	{
		if ($this->itemsPerPage && $this->pageName) {
			$this->db->pageName = $this->pageName;
			$this->db->setLimit($this->itemsPerPage);
			$this->totalCount = $this->db->getCount();
		}

		$lst = $this->db->sql_list ();
		$lst = $this->buildWithItems($lst);

		return $lst;
	}

	function getItem()
	{
		$this->db->setLimit(0);
		$item = $this->db->sql_fetch();

		if ($item) {
			$className = $this->itemModelClassName;
			return $className::build($item);
		}
		else
		{
			return null;
		}
	}

	public function buildWithItems($items)
	{
		$ret = array();
		$className = $this->itemModelClassName;
		foreach ($items as $k => $v) {
			$ret[] = $className::build($v);
		}

		return $ret;
	}

	public function getPaging($maxPagesToShow = 10)
	{
		if ($this->itemsPerPage == 0) return "";

		$page = (int)$this->request->request[$this->pageName];
		if ($page == 0)
			$page = 1;

		$p = new Paginator($this->totalCount, $this->itemsPerPage, $page, '');
		$p->setMaxPagesToShow($maxPagesToShow);

		$first = ptyRebuildUrl(array($this->pageName => 1));
		$prev = ptyRebuildUrl(array($this->pageName => $p->getPrevPage() ? $p->getPrevPage() : 1));
		$next = ptyRebuildUrl(array($this->pageName => $p->getNextPage() ? $p->getNextPage() : $p->getNumPages()));
		$last = ptyRebuildUrl(array($this->pageName => $p->getNumPages()));

		$out = "<ul class='pull-right pagination clearfix'>";
		$out .= "<li class='prev'><a href='$first' class='first'>처음</a></li>";
		$out .= "<li class='prev'><a href='$prev' class='prev'>이전</a></li>";

		foreach ($p->getPages() as $item) {

			if ($item['num'] == "...")
				$url = "";
			else
				$url = ptyRebuildUrl(array($this->pageName => $item['num']));

			if ($item[isCurrent])
				$out .= "<li class='active'><a href='$url'>" . $item[num] . "</a></li>";
			else
				$out .= "<li><a href='$url'>" . $item[num] . "</a></li>";
		}
		$out .= "<li class='next'><a href='$next' class='next'>다음</a></li>";
		$out .= "<li class='prev'><a href='$last' class='last'>마지막</a></li>";
		$out .= "</ul>";
		return $out;
	}

	public function remove($id)
	{
		$this->db->clear()->addFrom($this->_tableName)->addWhere("id = '$id'")->addSet("enabled = 0")->update();
	}


	public function delete($id)
	{
		$this->db->clear()->addFrom($this->_tableName)->addWhere("id = '$id'")->delete();
	}

	public function insert($item)
	{
		/** @var ptyDBItem $item */
		$this->db->clear()->addFrom($this->_tableName)->addSet($item->_item)->insert();
		$item->id = $this->db->getInsertId();
		return $item->id;
	}
}
