#!/usr/bin/php
<?php
$password = $argv[3] ?? null;
$host = $argv[1] ?? null;
$user = $argv[2] ?? null;
$backupPath = $argv[4] ?? null;

if (!$host)    $host = "localhost";
if (!$user)    $user = "root";
if (!$backupPath)    $backupPath = "/root/pty_server_backup/mysql";

// 패스워드가 없으면 ~/.mysql_password 파일에서 읽기 시도
if (!$password)
{
    // 먼저 로컬 ~/.mysql_password 체크
    echo "[INFO] Checking local ~/.mysql_password file...\n";
    $passwordFile = getenv("HOME") . "/.mysql_password";
    if (file_exists($passwordFile)) {
        $password = trim(file_get_contents($passwordFile));
        echo "[INFO] Password loaded from local ~/.mysql_password\n";
    } else {
        echo "[INFO] Local ~/.mysql_password not found\n";
    }

    // 로컬에 없고 호스트가 localhost가 아니면 SSH로 원격 호스트에서 가져오기
    if (!$password && $host != "localhost" && $host != "127.0.0.1") {
        echo "[INFO] Trying to get password from remote host ($host)...\n";
        $sshCmd = "ssh root@$host 'cat ~/.mysql_password' 2>/dev/null";
        $remotePassword = trim(shell_exec($sshCmd));
        if ($remotePassword) {
            $password = $remotePassword;
            echo "[INFO] Password loaded from remote host = $password\n";
        } else {
            echo "[INFO] Remote ~/.mysql_password not found\n";
        }
    }
}

if (!$password)
{
    echo "pty_mysql_backup_all_each_db_each_table version 1.0\n";
    echo "Copyright (C) 2019 by cpueblo, PlatyHouse Co.,LTD.\n";
    echo "Web site: https://www.platyhouse.com/\n\n";
    echo "Usage: php ./pty_mysql_backup_all_each_db_each_table.php <HOST> <USERNAME> <PASSWORD> [BACKUP_PATH]\n";
    echo "  HOST         : MySQL host (default: localhost)\n";
    echo "  USERNAME     : MySQL username (default: root)\n";
    echo "  PASSWORD     : MySQL password (optional if ~/.mysql_password exists)\n";
    echo "  BACKUP_PATH  : Backup directory path (default: /root/pty_server_backup/mysql)\n\n";
    echo "Or create ~/.mysql_password file with password\n";
    echo "Or create ~/.mysql_password file on the remote host\n";
    exit;
}


// 백업 디렉토리 생성
if (!is_dir($backupPath)) {
    echo "[INFO] Creating backup directory: $backupPath\n";
    if (!mkdir($backupPath, 0755, true)) {
        die("[ERROR] Failed to create backup directory: $backupPath\n");
    }
}

echo "\n[INFO] Backup path: $backupPath\n";
echo "[INFO] Connecting to MySQL server: $host as $user, password = $password\n";


$connection = mysqli_connect($host, $user, $password);
if (!$connection) {
    die ('[ERROR] Could not connect database.' . mysqli_error()."\n");
}
echo "[INFO] Connected successfully!\n\n";

echo "[INFO] Retrieving database list...\n";
$databases = mysqli_query($connection, "SHOW databases");
$dbCount = 0;
$totalTables = 0;
while ($databaseInfo = mysqli_fetch_array($databases)) { // go through each row that was returned in $result
    $dbName = $databaseInfo[0];

    # performance_schema, information_schema 는 백업 무시
    if ($dbName == "performance_schema" || $dbName == "information_schema") {
        echo "[SKIP] Skipping system database: $dbName\n";
        continue;
    }

    $dbCount++;
    echo "\n====================================\n";
    echo "[DB $dbCount] Processing database: $dbName\n";
    echo "====================================\n";

    $sql = "SHOW TABLES FROM `$dbName`";
    $result = mysqli_query($connection, $sql);

    if (!$result) {
        echo "[ERROR] DB Error, could not list tables\n";
        echo '[ERROR] MySQL Error: ' . mysqli_error($connection) . "\n";
        exit;
    }

    $tableCount = 0;
    $tables = [];
    while ($row = mysqli_fetch_row($result)) {
        $tables[] = $row[0];
    }

    $totalTablesInDb = count($tables);
    echo "[INFO] Found $totalTablesInDb tables in $dbName\n";

    foreach ($tables as $tableName) {
        $tableCount++;
        echo "[TABLE $tableCount/$totalTablesInDb] Backing up: $dbName.$tableName ... ";
        mysql_backup($host, $user, $password, $dbName, $tableName, $backupPath);
        echo "Done\n";
        $totalTables++;
    }
}

echo "\n====================================\n";
echo "[COMPLETE] Backup finished!\n";
echo "[STATS] Backup path: $backupPath\n";
echo "[STATS] Total databases: $dbCount\n";
echo "[STATS] Total tables: $totalTables\n";
echo "====================================\n";

function mysql_backup($host, $user, $password, $dbName, $tableName, $backupPath)
{
	if (strpos($dbName, "x_") === 0) {
        echo "(skipped: x_ prefix) ";
		return;
    }

    // 데이터베이스별 디렉토리 생성
    $dbDir = $backupPath . "/" . $dbName;
	if (!is_dir($dbDir)) {
        @mkdir($dbDir, 0755, true);
    }

    $outputFile = $dbDir . "/" . $tableName . ".sql";
    $cmd = "mysqldump -u $user -p$password -h $host $dbName $tableName --default-character-set=utf8mb4 --routines --events --add-drop-table --add-drop-database --complete-insert --extended-insert=TRUE --single-transaction --ssl-mode=DISABLED > \"$outputFile\" 2>&1";

    // 명령 실행 (출력 억제)
    exec($cmd, $output, $returnCode);

    if ($returnCode !== 0) {
        echo "\n[ERROR] Failed to backup $dbName.$tableName\n";
        echo implode("\n", $output) . "\n";
    }
}

?>
