#!/usr/bin/php
<?php

// CLI로 실행해야 하므로 PHP SAPI 확인
if (php_sapi_name() !== 'cli') {
    exit("이 스크립트는 CLI에서만 실행 가능합니다.\n");
}

// 사용자로부터 인자 입력받기
if ($argc < 2) {
    exit("사용법: php backup.php [database_name]\n");
}

$date = date("Ymd_His");
$databaseName = $argv[1];
$backupDir = "$databaseName";
$dumpFileTgz = "./{$databaseName}_{$date}_sql.tgz";
$dumpFile = "./{$databaseName}_{$date}.sql";
$zipFile =  "./{$databaseName}_{$date}_www.tgz";

// MySQL 설정 (환경에 맞게 수정)
$mysqlHost = 'localhost';
$mysqlUser = 'root';
$mysqlPassword = 'Tmxhfl!!00';

// 디렉터리 생성
if (!is_dir($backupDir)) {
    mkdir($backupDir, 0755, true);
}

// MySQL 덤프 실행
echo "MySQL 덤프 생성 중...\n";
$dumpCommand = sprintf(
    'mysqldump -h%s -u%s -p%s %s > %s',
    escapeshellarg($mysqlHost),
    escapeshellarg($mysqlUser),
    escapeshellarg($mysqlPassword),
    escapeshellarg($databaseName),
    escapeshellarg($dumpFile)
);

exec($dumpCommand, $output, $resultCode);
if ($resultCode !== 0) {
    exit("MySQL 덤프 실패: $dumpCommand\n");
}
exec ("tar cvzf $dumpFileTgz $dumpFile");
echo "MySQL 덤프 생성 완료: $dumpFile\n";

// 폴더 압축
echo "폴더 압축 중...\n";
$zipCommand = sprintf(
    'tar cvzf %s %s --warning=no-file-changed --ignore-failed-read',
    escapeshellarg($zipFile),
    escapeshellarg($backupDir)
);

exec($zipCommand, $output, $resultCode);
if ($resultCode !== 0) {
    exit("폴더 압축 실패: $zipCommand\n");
}
echo "폴더 압축 완료: $zipFile\n";

// 결과 출력
echo "백업 완료!\n";
echo "SQL 덤프 파일: $dumpFile\n";
echo "압축 파일: $zipFile\n";
