# pty_centos

Elasticsearch, MySQL, AI API 등 다양한 서비스를 다루는 CLI 도구 모음입니다.

## 설치

### 원격 설치 (권장)

신규 서버에서 다음 명령어 하나로 설치할 수 있습니다:

```bash
curl -sSL https://gitlab.platyhouse.com/platyhouse/centos/-/raw/master/ptyInstall.sh | bash
```

또는:

```bash
wget -qO- https://gitlab.platyhouse.com/platyhouse/centos/-/raw/master/ptyInstall.sh | bash
```

### 수동 설치

```bash
git clone https://gitlab.platyhouse.com/platyhouse/centos.git /var/lib/pty_centos.git
cd /var/lib/pty_centos.git
chmod +x pty*
./ptySetBash
source ~/.bashrc
```

## 설정 파일

각 서비스별 설정 파일을 홈 디렉토리에 생성해야 합니다:

| 서비스 | 설정 파일 |
|--------|----------|
| MySQL | `~/.ptyMysqlConfig.ini` |
| Elasticsearch | `~/.ptyElasticConfig.ini` |
| AI API | `~/.ptyAIConfig.ini` |

### ~/.ptyMysqlConfig.ini

```ini
[default]
host=localhost
username=root
password="your_password"
database=your_db
charset=utf8mb4

[production]
host=prod-server
username=admin
password="prod_password"
database=prod_db
charset=utf8mb4
```

### ~/.ptyElasticConfig.ini

```ini
[default]
host=https://localhost:9200
apiKey=your_api_key

[production]
host=https://prod-elastic:9200
apiKey=production_api_key
```

### ~/.ptyAIConfig.ini

```ini
[default]
provider=anthropic
model=claude-sonnet-4-5-20250514
apiKey=your_anthropic_api_key

[openai]
provider=openai
model=gpt-4o
apiKey=your_openai_api_key

[ollama]
provider=ollama
model=llama3
apiUrl=http://localhost:11434
```

---

## 스크립트 목록

모든 스크립트는 `--help` 옵션으로 상세 도움말을 확인할 수 있습니다.

### MySQL 도구

| 스크립트 | 설명 |
|---------|------|
| `ptyMysqlInfo` | MySQL 서버 정보 조회 |
| `ptyMysqlBackup` | 테이블 백업 (mysqldump) |
| `ptyMysqlRestore` | SQL/tgz 파일 복원 |
| `ptyMysqlOverwrite` | 서버 간 테이블 복사 |

### Elasticsearch 도구

| 스크립트 | 설명 |
|---------|------|
| `ptyElasticGetIndexs` | 인덱스 목록 조회 |
| `ptyElasticGetIndex` | 인덱스 상세 정보 |
| `ptyElasticGetIndexInfo` | 인덱스 매핑/설정 조회 |
| `ptyElasticUploadFromMysql` | MySQL → Elasticsearch 업로드 |

### AI API 도구

| 스크립트 | 설명 |
|---------|------|
| `ptyAIGetMessage` | AI API 메시지 전송 (Claude, GPT, Gemini, Ollama) |
| `ptyAIStatistics` | AI 사용량 통계 |

### 유틸리티

| 스크립트 | 설명 |
|---------|------|
| `ptyRun` | 스크립트 중복 실행 제어 + 로깅 |
| `ptyCronBuild` | 크론탭 자동 등록 |
| `ptySetBash` | Bash 환경 설정 |

---

## 사용 예시

### MySQL 백업/복원

```bash
# 단일 테이블 백업
ptyMysqlBackup mydb users

# 전체 백업 (압축)
ptyMysqlBackup '*' '*' --tgz --output=/backup

# 복원
ptyMysqlRestore "*" --input=/backup

# 서버 간 테이블 복사
ptyMysqlOverwrite --src-mysql=production --dst-mysql=development \
                  --src-db=prod_db --dst-db=dev_db \
                  --src-table=users --dst-table=users
```

### Elasticsearch

```bash
# 인덱스 목록
ptyElasticGetIndexs

# 인덱스 상세
ptyElasticGetIndex my_index

# MySQL 테이블을 Elasticsearch로 업로드
ptyElasticUploadFromMysql users users_index --recreate
```

### AI API

```bash
# Claude로 메시지 전송
ptyAIGetMessage "안녕하세요"

# GPT 사용
ptyAIGetMessage "Hello" --ai=openai

# JSON 출력
ptyAIGetMessage "테스트" --json
```

### 크론 + 중복 실행 제어

```bash
# 10분마다 실행, 중복 차단, 최대 10분 타임아웃
ptyCronBuild 'ptyRun "php /path/to/script.php" --max-run-time=10' --daily-10min
```

---

## 공통 옵션

모든 스크립트에서 사용 가능한 옵션:

| 옵션 | 설명 |
|------|------|
| `--help` | 도움말 출력 |
| `--verbose` | 상세 로그 출력 |
| `--edit` | 스크립트를 에디터로 열기 |
| `--dry-run` | 실제 실행 없이 미리보기 (데이터 변경 스크립트) |

서비스별 섹션 지정:

| 옵션 | 설명 |
|------|------|
| `--mysql=섹션명` | MySQL INI 섹션 (기본값: default) |
| `--elastic=섹션명` | Elasticsearch INI 섹션 (기본값: default) |
| `--ai=섹션명` | AI API INI 섹션 (기본값: default) |

---

## 라이선스

Private - PlatyHouse
