# CLAUDE.md

This file provides guidance to Claude Code (claude.ai/code) when working with code in this repository.

## 개요2

ptyLibrary_PHP는 PlatyHouse 프레임워크용 PHP 유틸리티 라이브러리입니다. 데이터베이스 작업, HTML 생성, CLI 유틸리티, 파일 관리, 웹 크롤링, 미디어 처리를 위한 재사용 가능한 컴포넌트를 제공합니다. 모든 코드는 `platyFramework` 네임스페이스를 사용합니다.

## 프로젝트 구조

```
ptyLibrary_PHP/
├── ptyLibrary.php          # 메인 진입점 - 모든 코어 모듈 include
├── common/                 # 핵심 유틸리티 함수 (ptyArray, ptyString, 디버그, HTTP)
├── database/               # MySQL 데이터베이스 추상화 레이어 (ptyMysql 클래스)
├── dbTableList/            # 데이터 목록 렌더링 및 페이지네이션
├── forms/                  # 파일 업로드 관리 (ptyFormFileManager)
├── cli/                    # CLI 유틸리티 및 ANSI 컬러 (ptyCliColor, ptyCliLog)
├── crawling/               # 웹 스크래핑 유틸리티 (ptyCrawling)
├── media/                  # 미디어 처리 (ptyYoutubePlay)
├── postBlog/               # XML-RPC 블로그 포스팅 (네이버, TypePad)
└── external/               # 외부 라이브러리 (PhpSpreadsheet, simpleHtmlDom, html2text)
```

## 주요 컴포넌트

### 데이터베이스 (ptyMysql)
Fluent 인터페이스 방식의 쿼리 빌더:
- `addSelect()`, `addFrom()`, `addJoin()`, `addWhere()`, `addWhereOr()`
- `addSet()`, `addOrderBy()`, `setLimit()`, `addGroupBy()`
- `insert()`, `update()`, `delete()`, `sql_query()`, `sql_fetch()`, `sql_list()`
- 날짜 필터: `getWhere이번달()`, `getWhere지난달()`, `getWhere1개월전부터()` 등
- Prepared statement 지원 (`binds` 파라미터), 쿼리 캐싱, 슬로우 쿼리 감지

헬퍼 함수: `mre()` (이스케이프), `mrea()` (따옴표 포함 이스케이프), `mreb()` (백틱 이스케이프)

### 공통 유틸리티 (common/common.php)
- **유효성 검사**: `ptyCheckEmpty()`, `ptyCheckNull()`, `ptyCheckEmptys()`
- **배열 처리**: `ptyTransformArray()`, `ptyGetMagicArray()`, `ptyArrayValueToKey()`
- **문자열 처리**: `ptyCutStr()`, `ptyCutLength()`, `ptyTrim()`, `ptyGetMiddleStr()`
- **HTTP**: `ptyGetCurrentUrl()`, `ptyGetUrlContent()`, `ptyCurlGet()`, `ptyCurlPost()`
- **디버그**: `ptyDebug()`, `ptyDebugXmp()`, `ptyDebugBackTrace()`, `ptyShowCallstack()`
- **JSON 응답**: `ptyJsonReturn()`, `ptyJsonReturnTrue()`, `ptyJsonReturnFalse()`
- **환경 감지**: `ptyIsCli()`, `ptyIsPC()`, `ptyIsCurl()`
- **크론 락**: `ptyCheckCronRunningDuplicate()`, `ptyEndCronRunningDuplicate()`

### CLI 로깅 (ptyCliLog)
컬러 터미널 출력, 로그 타입: 'info', 'success', 'warning', 'error', 'url', 'verbose', 'data', 'response'

## 사용 예시

```php
<?php
namespace platyFramework;
require_once("ptyLibrary.php");

// 데이터베이스 사용
$db = new ptyMysql($host, $user, $pass, $dbname);
$db->addSelect("*")->addFrom("users")->addWhere("active", 1);
$users = $db->sql_list();
```

## 코드 컨벤션

- **네임스페이스**: 모든 코드는 `platyFramework` 네임스페이스 사용
- **메소드 체이닝**: setter 메소드는 `$this` 반환
- **전역 상태**: 공유 설정에 `$GLOBALS['platyFramework']` 사용
- **Composer 미사용**: 직접 require를 통한 파일 기반 오토로딩
