<?php
namespace platyFramework;
/**
 * Created by PhpStorm.
 * User: cpueblo
 * Date: 2016. 8. 19.
 * Time: 오후 11:28
 */

class pagination
{
	public $total = 0;
	public $page = 1;
	public $limit = 20;
	public $num_links = 8;
	public $url = '';
	public $text_first = '|&lt;';
	public $text_last = '»|';
	public $text_next = '»';
	public $text_prev = '&lt;';

	function getUrl($AKey, $AVal, $r = null)
	{
		GLOBAL $SCRIPT_NAME;

		$Link = $SCRIPT_NAME;
		$Request = $r ? $r : $_REQUEST;
		$Param = 0;

		$bFound = FALSE;

		while (list ($key, $val) = each($Request)) {
			if ($key == "apmsetup_lng" || $key == "PhoneAgentNotice" || $key == "PHPSESSID")
				continue;

			if ($key == $AKey) {
				$bFound = TRUE;
				$val = $AVal;
			}

			if (is_array($val)) {
				foreach ($val as $k2 => $v2) {
					if ($Param) $Param .= "&"; else $Param = "?";
					$Param .= sprintf("%s[%s]=%s", $key, $k2, $v2);
				}
			} else {
				if ($Param) $Param .= "&"; else $Param = "?";
				$Param .= "$key=$val";
			}
		}

		if (!$bFound) {
			if ($Param) $Param .= "&"; else $Param = "?";
			$Param .= "$AKey=$AVal";
		}

		return $Link . $Param;
	}

	// 파라미터를 유지하면서 신규 또는 변경된 파라미터를 갖게 해주는 함수
	// rebuildURL (array("sort" => "value"))
	function rebuildURL($array)
	{
		GLOBAL $SCRIPT_NAME;

		$Link = $SCRIPT_NAME;
		$Request = $r ? $r : $_REQUEST;

		$Request = array_merge($Request, $array);

		foreach ($Request as $k => $v) {
			if (is_array($v)) {
				foreach ($v as $k2 => $v2) {
					if ($s) $s .= "&";
					$s .= sprintf("%s[%s]=%s", $k, $k2, $v2);
				}
			} else {
				if ($s) $s .= "&";
				$s .= "$k=$v";
			}
		}

		return sprintf("%s?%s", $SCRIPT_NAME, $s);
	}

	public function render()
	{
		$total = $this->total;
		$this->url = $this->getUrl("page", "{page}");

		if ($this->page < 1) {
			$page = 1;
		} else {
			$page = (int)$this->page;
		}

		if (!(int)$this->limit) {
			$limit = 20;
		} else {
			$limit = $this->limit;
		}

		$num_links = $this->num_links;
		$num_pages = ceil($total / $limit);

		/*
		echo "total = $total<br>";
		echo "url = ".$this->url."<br>";
		echo "page = ".$this->page."<br>";
		echo "limit = ".$this->limit."<br>";
		echo "num_links = ".$num_links."<br>";
		echo "num_pages = ".$num_pages."<br>";
		*/

		$this->url = str_replace('%7Bpage%7D', '{page}', $this->url);
		$output = '<ul class="pagination pagination-sm no-margin">';

		if ($page > 1) {
			$output .= '<li><a href="' . $this->getUrl("page", "1") . '">' . $this->text_first . '</a></li>';
			if ($page - 1 === 1) {
				$output .= '<li><a href="' . $this->getUrl("page", "1") . '">' . $this->text_prev . '</a></li>';
			} else {
				$output .= '<li><a href="' . $this->getUrl("page", $page - 1) . '">' . $this->text_prev . '</a></li>';
			}
		}

		if ($num_pages >= 1) {
			if ($num_pages <= $num_links) {
				$start = 1;
				$end = $num_pages;
			} else {
				$start = $page - floor($num_links / 2);
				$end = $page + floor($num_links / 2);

				if ($start < 1) {
					$end += abs($start) + 1;
					$start = 1;
				}

				if ($end > $num_pages) {
					$start -= ($end - $num_pages);
					$end = $num_pages;
				}
			}

			for ($i = $start; $i <= $end; $i++) {
				if ($page == $i) {
					$output .= '<li class="active"><span>' . $i . '</span></li>';
				} else {
					if ($i === 1) {
						$output .= '<li><a href="' . $this->getUrl("page", "1") . '">' . $i . '</a></li>';
					} else {
						$output .= '<li><a href="' . $this->getUrl("page", $i) . '">' . $i . '</a></li>';
					}
				}
			}
		}

		if ($page < $num_pages) {
			$output .= '<li><a href="' . str_replace('{page}', $page + 1, $this->url) . '">' . $this->text_next . '</a></li>';
			$output .= '<li><a href="' . str_replace('{page}', $num_pages, $this->url) . '">' . $this->text_last . '</a></li>';
		}

		$output .= '</ul>';

		if ($num_pages > 0) {
			return $output;
		} else {
			return '';
		}
	}
}
