<?php

// MySQL 연결 설정
$host = 'localhost';
$user = 'root';
$password = 'Tmxhfl!!00';

// 6개월 전 날짜 계산
$sixMonthsAgo = date('Y-m-d H:i:s', strtotime('-6 months'));

// MySQL 연결
$conn = new mysqli($host, $user, $password);
if ($conn->connect_error) {
    die("MySQL 연결 실패: " . $conn->connect_error . "\n");
}

// 쿼리 실행
$query = "
    SELECT table_schema AS database_name, MAX(update_time) AS last_used
    FROM information_schema.tables
    WHERE table_schema NOT IN ('mysql', 'information_schema', 'performance_schema', 'sys')
    GROUP BY table_schema
    # HAVING MAX(update_time) < '$sixMonthsAgo' OR MAX(update_time) IS NULL
	ORDER BY last_used DESC;
";

$result = $conn->query($query);
if (!$result) {
    die("쿼리 실행 실패: " . $conn->error . "\n");
}



// 결과 출력
echo str_repeat("=", 80) . "\n";
printf("| %-30s | %-20s | %-15s |\n", "Database Name", "Last Used", "Days Since");
echo str_repeat("=", 80) . "\n";

while ($row = $result->fetch_assoc()) {
    $databaseName = $row['database_name'];
    $lastUsed = isset($row['last_used']) ? $row['last_used'] : 'Never used';

    if ($lastUsed !== 'Never used') {
        $daysElapsed = floor((time() - strtotime($lastUsed)) / (60 * 60 * 24));
        printf("| %-30s | %-20s | %-15s |\n", $databaseName, $lastUsed, "$daysElapsed days");
    } else {
        printf("| %-30s | %-20s | %-15s |\n", $databaseName, "Never used", "N/A");
    }
}

echo str_repeat("=", 80) . "\n";


// MySQL 연결 종료
$conn->close();
