#!/usr/bin/php
<?php

// CLI에서 폴더 경로 입력 받기
$folderPath = isset($argv[1]) ? $argv[1] : "";

if ($folderPath === "") {
    // 현재 디렉토리 설정
    $folderPath = getcwd();
}

if (!is_dir($folderPath)) {
    die("입력한 경로가 유효한 폴더가 아닙니다.\n");
}

// 현재 폴더의 하위 폴더 목록 가져오기
$folders = array_filter(glob($folderPath . DIRECTORY_SEPARATOR . '*'), 'is_dir');

if (empty($folders)) {
    die("현재 디렉토리에 하위 폴더가 없습니다.\n");
}

$folderData = []; // 각 폴더의 데이터를 저장할 배열

// 각 폴더의 최신 파일 날짜 계산
foreach ($folders as $folder) {
    $iterator = new RecursiveIteratorIterator(
        new RecursiveDirectoryIterator($folder, RecursiveDirectoryIterator::SKIP_DOTS)
    );

    $latestTimestamp = 0; // 각 폴더의 최신 날짜 저장
    $latestFilePath = ""; // 최신 파일의 경로 저장

    foreach ($iterator as $file) {
        if ($file->isFile()) {
            $fileCreationTime = filectime($file->getPathname());
            if ($fileCreationTime > $latestTimestamp) {
                $latestTimestamp = $fileCreationTime;
                $latestFilePath = $file->getPathname();
            }
        }
    }

    $folderName = basename($folder);
    $folderData[] = [
        'folderName' => $folderName,
        'latestTimestamp' => $latestTimestamp,
        'latestFilePath' => $latestFilePath ?: "No files"
    ];
}

// 최신 파일 날짜 기준으로 정렬 (오래된 것이 아래로)
usort($folderData, function ($a, $b) {
    if ($a['latestTimestamp'] == $b['latestTimestamp']) {
        return 0;
    }
    return ($a['latestTimestamp'] > $b['latestTimestamp']) ? -1 : 1; // 최신 파일 날짜가 오래된 것이 아래로
});

// 결과 출력
echo str_repeat("=", 120) . "\n";
printf("| %-30s | %-20s | %-40s |\n", "Folder Name", "Latest File Date", "File Path");
echo str_repeat("=", 120) . "\n";

foreach ($folderData as $data) {
    $latestDate = $data['latestTimestamp'] > 0 ? date("Y-m-d H:i:s", $data['latestTimestamp']) : "N/A";
    printf(
        "| %-30s | %-20s | %-40s |\n",
        $data['folderName'],
        $latestDate,
        $data['latestFilePath']
    );
}

echo str_repeat("=", 120) . "\n";

