<?php

namespace platyFramework;

class ptyYoutubePlay
{
	var $text;
	var $width = 0;
	var $height = 0;

	function __construct($text)
	{
		$this->text = $text;
	}

	function setWidthHeight($width, $height)
	{
		$this->width = $width;
		$this->height = $height;
	}

	static function getYoutubeId($url)
	{
		$url = parse_url($url);

		// youtube
		if (in_array($url['host'], array(
				'www.youtube.com',
				'youtube.com'
			)) && $url['path'] == '/watch' && isset($url['query'])
		) {
			parse_str($url['query'], $query);

			return $query['v'];
		}

		// youtube
		if (in_array($url['host'], array(
			'youtu.be',
			'm.youtube.com'
		))) {
			parse_str($url['query'], $query);
			$query[v] = $url[path];

			return $query['v'];
		}

		return "";
	}

	function getId()
	{
		$url = parse_url($this->text);

		// youtube
		if (in_array($url['host'], array(
				'www.youtube.com',
				'youtube.com'
			)) && $url['path'] == '/watch' && isset($url['query'])
		) {
			parse_str($url['query'], $query);

			return $query['v'];
		}

		// youtube
		if (in_array($url['host'], array(
			'youtu.be',
			'm.youtube.com'
		))) {
			parse_str($url['query'], $query);
			$query[v] = $url[path];

			return $query['v'];
		}

		return "";

	}

	function get()
	{
		$url = parse_url($this->text);

		// youtube
		if (in_array($url['host'], array(
				'www.youtube.com',
				'youtube.com'
			)) && $url['path'] == '/watch' && isset($url['query'])
		) {
			parse_str($url['query'], $query);

			$width = $this->width ? $this->width : 640;
			$height = $this->height ? $this->height : 480;

			// return sprintf('<iframe class="embedded-video" src="/board/item/youtube/?id=%s&width=%d&height=%d" allowfullscreen width="%s" height="%s" frameBorder=0></iframe>', $query['v'], $width, $height, $width, $height);
			return sprintf('<iframe class="embedded-video" src="//www.youtube.com/embed/%s" allowfullscreen width="%s" height="%s" frameBorder=0></iframe>', $query['v'], $width, $height);
		}

		// youtube
		if (in_array($url['host'], array(
			'youtu.be',
			'm.youtube.com'
		))) {
			parse_str($url['query'], $query);
			$query[v] = $url[path];

			$width = $this->width ? $this->width : 640;
			$height = $this->height ? $this->height : 480;
			return sprintf('<iframe class="embedded-video" src="//www.youtube.com/embed/%s" allowfullscreen width="%s" height="%s" frameBorder=0></iframe>', $query['v'], $width, $height);
		}

		return "";
	}

	function getStyle2()
	{
		$url = parse_url($this->text);

		// youtube
		if (in_array($url['host'], array(
				'www.youtube.com',
				'youtube.com'
			)) && $url['path'] == '/watch' && isset($url['query'])
		) {
			parse_str($url['query'], $query);

			$width = $this->width ? $this->width : 640;
			$height = $this->height ? $this->height : 480;
			return sprintf('<iframe class="embedded-video" src="//www.youtube.com/embed/%s?autohide=1&modestbranding=1&fs=0&controls=0&rel=0&showinfo=0" allowfullscreen width="%s" height="%s" frameBorder=0></iframe>', $query['v'], $width, $height);
		}

		// youtube
		if (in_array($url['host'], array(
			'youtu.be',
			'm.youtube.com'
		))) {
			parse_str($url['query'], $query);
			$query[v] = $url[path];

			$width = $this->width ? $this->width : 640;
			$height = $this->height ? $this->height : 480;
			return sprintf('<iframe class="embedded-video" src="//www.youtube.com/embed/%s?autohide=1&modestbranding=1&fs=0&controls=0&rel=0&showinfo=0" allowfullscreen width="%s" height="%s" frameBorder=0></iframe>', $query['v'], $width, $height);
		}

		return "";
	}

}

?>
