<?php
namespace platyFramework;

/**
 * 공용 Config 를 관리합니다
 *
	get) $config = $this->config->getConfig("app");
	$data['intro'] = $config->intro;

	set)
    $this->config->setConfig("app", ["intro" => $p->item->intro]);
 */
class ptyconfigItemsModel extends ptyItemsModel
{
	var $_tableName = "t_pty_config";
	var $_serviceUserId = "";

	function _migrate()
	{
		// GLOBAL $platyFramework;
		// $this->db = $platyFramework->db;

		if (!$this->db->sql_result("SHOW TABLES LIKE '$this->_tableName'")) {
			$this->db->sql_query("
			CREATE TABLE IF NOT EXISTS `{$this->_tableName}` (
			`id` int(11) NOT NULL AUTO_INCREMENT,
			`descId` int(11) NULL DEFAULT 0, 
			`enabled` tinyint(1) NOT NULL DEFAULT '1',
			
			`regDateTime` datetime NULL,
			`ip` varchar(64) NULL DEFAULT '',
			 
			`serviceUserId` varchar(64) null default 'default',
            `group` varchar(64)  NULL,
            `key` varchar(64)  NULL,
            `value` text  NULL,
            
			PRIMARY KEY (`id`),
			UNIQUE KEY `keys` (`serviceUserId`, `group`, `key`)
			) ENGINE=InnoDB DEFAULT CHARSET=" . PLATYFRAMEWORK_DB_CHARSET . " COLLATE=" . PLATYFRAMEWORK_DB_COLLATE . " AUTO_INCREMENT=1;
		");
		}
	}

    /**
     * @param $groupName
     * @param string $key
     * @return bool|ptyArrayItemModel|string
     */
    public function getConfig($groupName, $key = "")
	{
        $this->db->clear();
        // $this->db->setDebug(1);

        if ($key != "")
		{
            $result = $this->db->sql_result("SELECT `value` FROM {$this->_tableName} WHERE `serviceUserId` = '$this->_serviceUserId' and `group` = '$groupName' and `key` = '$key'");
            return $result;
		}
		else {
            $items = $this->db->sql_list4("SELECT `key`, `value` FROM {$this->_tableName} WHERE `serviceUserId` = '$this->_serviceUserId' and `group` = '$groupName'");
            return ptyArrayItemModel::buildItem($items);
        }
	}

    /**
     * @param $groupName
     * @param $values ptyArrayItemModel
     */
    public function setConfig($groupName, $values)
	{
		$groupName = addslashes($groupName);
		foreach ($values->_item as $k => $v) {
			$k = addslashes($k);
			$v = addslashes($v);

			$this->db->clear();
			$this->db->query("INSERT INTO {$this->_tableName} SET `serviceUserId` = '$this->_serviceUserId', `group` = '$groupName', `key` = '{$k}', `value` = '$v'
				ON DUPLICATE KEY UPDATE `value` = '$v'");
		}
	}

	// public function modify($groupName)

    /**
	 * @return ptyConfigUserItemModel
	 */
	public function x_getUser()
	{
		return $this->get("user");
	}

	/**
	 * @return ptyConfigSMSAPIItemModel
	 */
	public function x_getSMSAPI()
	{
		return $this->get("sms_api");
	}

	/**
	 * @return ptyConfigSystemItemModel
	 */
	public function x_getSystem()
	{
		return $this->get("system");
	}


	/**
	 * @param $groupName
	 *
	 * @return ptyItemModel
	 */
	public function x_get($service_serviceId, $groupName)
	{
		$this->db->clear();
		$items = $this->db->sql_list4("SELECT `key`, `value` FROM {$this->_tableName} WHERE `service_serviceId` = '$service_serviceId' and `group` = '$groupName'");

		return ptyItemModel::buildItem($this->_tableName, $items);
	}

	public function x_getGroupNames()
	{
		$items = $this->db->sql_list2("SELECT `group` FROM {$this->_tableName} GROUP BY `group`");
		return $items;
	}

	public function x_insert($controller, $class, $function, $returnValue)
	{
		GLOBAL $platyFramework;

		$fullUrl = (isset($_SERVER['HTTPS']) ? "https" : "http") . "://" . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
		$getParams = $_SERVER['REQUEST_URI'];
		$postParams = json_encode($_POST, JSON_UNESCAPED_UNICODE);

		if ($platyFramework->loginUserItem)
			$userId = $platyFramework->loginUserItem->id;
		else
			$userId = 0;

		$n = $platyFramework->db->query("INSERT INTO {$this->_tableName} (regDateTime, ip, userAgent, userId, controller, class, function, fullUrl, getParams, postParams, returnValue) VALUES
      (
      NOW(), '{$_SERVER['REMOTE_ADDR']}', '{$_SERVER['HTTP_USER_AGENT']}',
      {$userId},
      '" . addslashes($controller) . "', 
      '" . addslashes($class) . "', 
      '" . addslashes($function) . "', 
      '" . addslashes($fullUrl) . "', 
      '" . addslashes($getParams) . "', 
      '" . addslashes($postParams) . "',
      '" . addslashes($returnValue) . "')");

		$id = $platyFramework->db->getInsertId();
		if ($id)
			$platyFramework->db->sql_query("UPDATE $this->_tableName SET descId = " . ($id * -1) . " WHERE id = $id");

		$platyFramework->appInboundLogInsertId = $id;
	}

    public function setServiceUserId($serviceUserId)
    {
    	$this->_serviceUserId = $serviceUserId;
    	return $this;
    }
}

/**
 * Class ptyConfigUserItemModel
 * @package platyFramework
 * @property int        registerMarriedPoint 결혼 유무
 * @property int        registerProfileImagePoint
 * @property int        registerEmailPoint
 * @property int        registerBirthdayPoint
 * @property int        registerPhoneNumberPoint
 * @property mixed|null phoneNumberAuthMessage
 */
class x_ptyConfigUserItemModel extends ptyItemModel
{

}

/**
 * Class ptyConfigSMSAPIItemModel
 * @package platyFramework
 * @property int phps_userId 결혼 유무
 * @property int phps_authKey
 * @property int phps_senderNumber
 */
class x_ptyConfigSMSAPIItemModel extends ptyItemModel
{
}

/**
 * Class ptyConfigSystemItemModel
 *
 * @property appName 앱명칭
*/


class x_ptyConfigSystemItemModel extends ptyItemModel
{

}

?>
