<?php
/**
 * Copyright (c) 2016. PlatyHouse. all rights reserved.
 */

namespace platyFramework;

/**
 * Class ptyArrayItemModel
 * @package platyFramework
 * @author cpueblo <cpueblo@platyhouse.com>
 *
 * @property $id
 */
class ptyArrayItemModel extends model
{
    var $_item = array();

    public function __construct($item = null, $decode = true)
    {
        parent::__construct();
        $this->initItem($this->_item, $item, $decode);
    }

    public function initItem(&$stored, $item, $decode = true)
    {
        if (is_array($item)) {

            foreach ($item as $k => $v) {

                if (is_array($v)) {
                    $stored[$k] = self::buildItem($v);
                } else {

//                    if ($decode) {
//                        $data = htmlspecialchars_decode($v);
//                        if (!is_null($v) && !get_magic_quotes_gpc()) {
//                            $v = stripslashes($v);
//                        }
//                    }
                    $stored[$k] = $v;
                }
            }
        }
    }

    /*
    public static function buildWithItems($items)
    {
        $ret = array();
        foreach ($items as $k => $v) {
            $ret[] = static::buildItem($v);
        }

        return $ret;
    }
    */
    public static function buildItem($item = null, $decode = true)
    {
        // $n = new self($item);
        $n = new static ($item, $decode);
        return $n;
    }

    public static function buildByMap($item)
    {
        $n = new static ();
        $n->_item = $item;
        return $n;
    }

    public static function buildItemByArray($items)
    {
        $ret = array();
        foreach ($items as $k => $v) {
            $ret[] = static::buildItem($v);
        }

        return $ret;
    }


    public function __get($key)
    {
        if (isset($this->_item[$key])) {
            return $this->_item[$key];
        } else return parent::__get($key);
    }

    public function __set($key, $value)
    {
        $this->_item[$key] = $value;
    }

    public function debug()
    {
        ptyDebug($this->_item);
    }


    /**
     * $newItem 의 배열 항목을 가져옵니다
     * ex) $item->getFromArrayItem($newItem, ["storeTitle", "name", "phoneNumber" => "newItemsnumber"]);
     *
     * @param $newItem
     * @param $array
     * @copyright 2020.04.09. cpueblo.
     */
    public function getFromArrayItem($newItem, $array)
    {
        foreach ($array as $k => $v) {
            if (is_int($k)) {
                $left = $v;
                $right = $v;
            } else {
                $left = $k;
                $right = $v;
            }
            $this->_item[$left] = $newItem->_item[$right];
        }
    }

    /**
     * ptyArrayItems 형식의 items 의 배열만을 추출합니다
     *
     * @param $items
     * @return array
     */
    public static function getArrayFromItem($items)
    {

        $ret = array();
        foreach ($items as $item) {
            $ret[] = $item->_item;
        }
        return $ret;
    }

    /**
     * ptyArrayItems 형식의 items 의 배열만을 추출합니다
     *
     * @param $items
     * @return array
     */
    public static function getArray($items)
    {
        // echo "============ getArray ";
        //print_r($items);

        foreach ($items as $idx => $item) {
            // $ret[$idx] = $item;

            if ($item instanceof ptyItemModel) {

                foreach ($item->_item as $k => $v) {
//                    echo "k : $k ==> ";
//                    print_r($v);
//                    echo "\n";

                    if (is_array($v)) {
                        $ret[$idx][$k] = self::getArray($v);
                    } else {
                        $ret[$idx][$k] = $v;
                    }

                    /*
                    if ($v instanceof ptyItemModel) {
                        $ret[$idx][$k] = self::getArray($v->_item);
                    } else
                        $ret[$idx][$k] = $v;
                    */
                }

                // $ret[$idx] = $item->_item;
            } else {
                $ret[$idx] = $item;
            }
        }
        return $ret;
    }


    /**
     * 아이템 배열을 리턴합니다
     * 파라미터의 인자중 특정 배열을 업데이트 할 경우에 유용합니다
     * 2018-12-15
     *
     * @param array $array
     * @return ptyArrayItemModel
     */
    /*
    ex)
            $item = siteItemsModel::buildItem(
                $params->getItem(
                    ["id" => "siteId", "customerUserId", "title", "company", "mainCategory", "subCategory", "workKeyword", "location", "peoples", "managerName", "managerPhoneNumber", "managerEmail", "payMethod", "realtimeVideoUrl"]
                )
            );

            $item->userId = $this->signedInItem->userId;
            $item->modify();

    ex)
    $item->getItem(["id" => "siteId", "title", "company", "mainCategory", "subCategory", "workKeyword", "location", "peoples", "managerName", "managerPhoneNumber", "managerEmail", "payMethod", "realtimeVideoUrl"]);

    return's id => $item['siteId']
    return's title => $item['title']

     */
    public function getKeyValues($array)
    {
        $ret = new static();
        if (is_array($array)) {
            foreach ($array as $k => $v) {

                if (!isset($this->_item[$v]))
                    continue;

                // ["aa", "bb"] 형태일 경우
                if (is_int($k)) {
                    $ret->$v = $this->_item[$v];
                } else {
                    $ret->$k = $this->_item[$v];
                }
            }
        }
        /*
        else
        {
            foreach ($array->_item as $k => $v) {
                $ret->$k = $this->_item[$k];
            }
        }
        */
        return $ret;
    }

    /**
     * $dest 의 필드를 $array 의 필드들로 교체합니다
     *
     * ex) $item->replaceItemByItem($item, $p->getItem(["companyName", "mainCategory", "subCategory", "workKeyword", "location", "workSpace"]));
     * @param ptyArrayItemModel $dest
     * @param ptyArrayItemModel $array
     * @return ptyArrayItemModel
     */
    public function replaceItemByItem($array)
    {
        if (is_array($array)) {
            foreach ($array as $k => $v) {
                if (is_int($k))
                    $this->$v = $array->_item[$v];
                else
                    $this->$k = $array->_item[$v];
            }
        } else {
            foreach ($array->_item as $k => $v) {
                $this->$k = $array->_item[$k];
            }
        }
        return $this;
    }

    public function replaceItemByArray($array)
    {
        foreach ($array as $k => $v) {
            $this->$k = $array[$k];
        }

        return $this;

    }

    /**
     * $dest 의 필드를 json 필드로 교체(추가) 합니다
     * ex) $item->replaceItemByJsonColumn($item->data_result1);
     * @param string $str
     */
    public function replaceItemByJsonColumn($str)
    {
        $j = json_decode($str, true);
        debug($j, "replaceItemByJsonColumn");
        return $this->replaceItemByArray($j);
    }

    /**
     * Item 클래스의 Property, DB 의 컬럼, Item 세팅에 대한 도움이 되는 내용을 출력합니다
     *
     */
    public function showPropertyDoc()
    {
        $out = "";
        $out .= "------------------------------\n";
        foreach ($this->_item as $k => $v) {
            $out .= "* @property string $" . $k . "\n";
        }

        $out .= "------------------------------\n";
        foreach ($this->_item as $k => $v) {
            $out .= "`$k` varchar(64) null default '' comment '', \n";
        }

        $out .= "------------------------------\n";
        foreach ($this->_item as $k => $v) {
            $out .= "$" . "item->{$k} = $" . "params->$k; \n";
        }

        ptyDebug($out);
    }

    /**
     * ptyArrayItem[] 의 형식을 이용하여 $keys => id 형태로 리턴합니다. 주로 select 에 사용됩니다
     *
     * @param ptyArrayItemModel[] $items
     * @param $keys
     * @return array
     *
     * ex) if ($this->request->req->output == "select") {
     * return ["items" => ptyArrayItemModel::getArrayById($ret, "차량번호 : @carNo")];
     * }
     */
    public static function getArrayById($items, $keys, $idKey = "id")
    {
        $rets = array();
        foreach ($items as $item) {
            if (is_array($item)) $item = ptyArrayItemModel::buildItem($item);

            $out = $keys;
            foreach ($item->_item as $key => $value) {
                $out = str_replace("@{$key}", $value, $out);
            }
            // ptyDebug($idKey);
            $rets[$out] = $item->$idKey;
        }

        return $rets;

    }

}

?>