#!/usr/bin/php
<?php
$password = $argv[1];
$host = $argv[2];
$user = $argv[3];
if (!$password)
{
    echo "pty_mysql_backup.sh version 1.0\n";
    echo "Copyright (C) 2019 by cpueblo, PlatyHouse Co.,LTD.\n";
    echo "Web site: https://www.platyhouse.com/\n\n";
    echo "Usage ./pty_mysql_backup_all_database.sh <MYSQL ROOT PASSWORD> <HOST (default: localhost)> <USERNAME (default: root)> <DBNAME>\n";
    exit;
}

if (!$host)    $host = "localhost";
if (!$user)    $user = "root";

$connection = mysqli_connect($host, $user, $password);
if (!$connection) {
    die ('Could not connect database.' . mysqli_error()."\n");
}

$databases = mysqli_query($connection, "SHOW databases");
while ($databaseInfo = mysqli_fetch_array($databases)) { // go through each row that was returned in $result
    $dbName = $databaseInfo[0];

    if ($dbName == "performance_schema")
        continue;

    if ($dbName == "mysql")
        continue;

    if ($dbName == "sys")
        continue;

    if ($dbName == "information_schema")
        continue;


    echo "====================================\ndatabase = $dbName\n====================================\n";
    mysql_backup($host, $user, $password, $dbName);
}

echo "finished\n";
mysqli_close($connection);

function mysql_backup($host, $user, $password, $dbName)
{
    $cmd = "mysqldump -u $user -p$password -h $host $dbName --add-drop-table --add-drop-database --complete-insert --extended-insert > pty_mysql_backup_$dbName.sql";
    echo $cmd;
    system($cmd);
}

?>
