#!/usr/bin/php
<?php
$password = $argv[1];
$host = $argv[2];
$user = $argv[3];
if (!$password)
{
    echo "pty_mysql_backup_all_table.sh version 1.0\n";
    echo "Copyright (C) 2019 by cpueblo, PlatyHouse Co.,LTD.\n";
    echo "Web site: https://www.platyhouse.com/\n\n";
    echo "Usage ./pty_mysql_backup_all_table.sh <MYSQL ROOT PASSWORD> <HOST (default: localhost)> <USERNAME (default: root)> <DBNAME>\n";
    exit;
}

if (!$host)    $host = "localhost";
if (!$user)    $user = "root";


$connection = mysqli_connect($host, $user, $password);
if (!$connection) {
    die ('Could not connect database.' . mysqli_error()."\n");
}

$databases = mysqli_query($connection, "SHOW databases");
while ($databaseInfo = mysqli_fetch_array($databases)) { // go through each row that was returned in $result
    $dbName = $databaseInfo[0];

    if ($dbName == "performance_schema")
        continue;

    if ($dbName == "mysql")
        continue;

    if ($dbName == "sys")
        continue;

    if ($dbName == "information_schema")
        continue;

    echo "====================================\ndatabase = $dbName\n====================================\n";

    $sql = "SHOW TABLES FROM `$dbName`";
    $result = mysqli_query($connection, $sql);

    if (!$result) {
        echo "DB Error, could not list tables\n";
        echo 'MySQL Error: ' . mysqli_error($connection);
        exit;
    }

    while ($row = mysqli_fetch_row($result)) {
        $tableName = $row[0];
        mysql_backup($host, $user, $password, $dbName, $tableName);
    }
}


echo "finished\n";

function mysql_backup($host, $user, $password, $dbName, $tableName)
{
    $cmd = "mysqldump -u $user -p$password -h $host $dbName $tableName --default-character-set=utf8mb4 --add-drop-table --add-drop-database --complete-insert --extended-insert=FALSE --single-transaction > pty_mysql_backup_all_table_{$dbName}.{$tableName}.sql";
    echo "{$cmd}\n";

    system($cmd);
}

?>
