<?php
namespace platyFramework;

class ptyElapsedTime
{
    private $startTime;

    public function __construct()
    {
        $this->startTime = microtime(true);
    }

    /**
     * 경과 시간을 밀리초(ms) 단위로 반환
     * @return int 경과 시간 (밀리초)
     */
    public function get()
    {
        $endTime = microtime(true);
        $elapsedSeconds = $endTime - $this->startTime;
        return round($elapsedSeconds * 1000); // 초를 밀리초로 변환 후 반올림
    }

    /**
     * 시작 시간을 현재 시간으로 리셋
     */
    public function reset()
    {
        $this->startTime = microtime(true);
    }
}