# CLAUDE.md

이 파일은 Claude Code가 이 저장소의 코드 작업 시 참고하는 가이드입니다.

## 프로젝트 개요

pty_centos.git은 Elasticsearch, MySQL 등 다양한 서비스를 다루는 CLI 도구 모음입니다.

## 네임스페이스

모든 PHP 코드는 `platyFramework` 네임스페이스를 사용합니다.

## ptyElastic* 스크립트 작성 규칙

새로운 Elasticsearch CLI 스크립트 생성 시 다음 패턴을 따릅니다:

### 필수 구조

```php
#!/usr/bin/env php
<?php
/**
 * 스크립트 설명
 *
 * 설정 파일: ~/.ptyElasticConfig.ini
 *
 * Usage: ./ptyElasticXXX <args> [options]
 */

namespace platyFramework;

require_once __DIR__ . '/ptyLibrary_PHP/cli/ptyCliOptionParser.php';
require_once __DIR__ . '/ptyLibrary_PHP/elastic/ptyElasticConfig.php';

// 인자 파싱
$parsed = ptyCliOptionParser::parse($argv);
$positionalArgs = $parsed['positional'];
$options = $parsed['options'];
$elasticSection = $options['elastic'] ?? 'default';
$verbose = isset($options['verbose']);

// 도움말 또는 필수 인자 확인
if (/* 필수 인자 누락 */ || isset($options['help'])) {
    echo "사용법: {$argv[0]} <필수인자> [옵션]\n";
    echo "\n";
    echo "옵션:\n";
    echo "  --elastic=섹션명    INI 파일 섹션 (기본값: default)\n";
    echo "  --verbose           상세 로그 출력\n";
    echo "  --help              도움말 출력\n";
    echo "\n";
    // ... 추가 도움말 ...
    echo "설정 파일: ~/.ptyElasticConfig.ini\n";
    echo ptyElasticConfig::getConfigExample() . "\n";
    exit(isset($options['help']) ? 0 : 1);
}

try {
    // Elasticsearch 연결
    $connection = ptyElasticConfig::connect($elasticSection);
    $elastic = $connection['client'];
    $elastic->setDebug($verbose);  // --verbose 옵션에 따라 로그 제어
    $config = $connection['config'];
    $authMethod = $connection['authMethod'];

    // ... 비즈니스 로직 ...

} catch (\Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    exit(1);
}
```

### 필수 옵션

| 옵션 | 설명 |
|------|------|
| `--elastic=섹션명` | INI 파일 섹션 지정 (기본값: default) |
| `--verbose` | 상세 로그 출력 (기본: 비활성화) |
| `--help` | 도움말 출력 |

### 주요 클래스/함수

- `ptyCliOptionParser::parse($argv)` - CLI 인자 파싱 (positional, options 분리)
- `ptyElasticConfig::connect($section)` - Elasticsearch 연결 및 클라이언트 반환
- `ptyElasticConfig::getConfigExample()` - 설정 파일 예시 문자열 반환
- `$elastic->setDebug($verbose)` - 상세 로그 활성화/비활성화

### Exit 코드

- `0`: 정상 종료 (--help 포함)
- `1`: 에러 또는 필수 인자 누락

## ptyLibrary_PHP 구조

```
ptyLibrary_PHP/
├── cli/
│   ├── ptyCliOptionParser.php  # CLI 옵션 파서
│   ├── ptyCliLog.php           # 컬러 로깅
│   └── ptyCliColor.php         # ANSI 색상 코드
├── elastic/
│   ├── ptyElasticConfig.php    # Elasticsearch 설정 로더
│   └── Elastic.php             # Elasticsearch 클라이언트
└── ...
```

## 설정 파일

### ~/.ptyElasticConfig.ini

```ini
[default]
host=https://localhost:9200
apiKey=your_api_key

# 또는 user/password 방식
# user=elastic
# password="your_password"

[production]
host=https://prod-elastic:9200
apiKey=production_api_key
```

### ~/.ptyMysqlConfig.ini

```ini
[default]
host=localhost
username=root
password="your_password"
database=your_db
charset=utf8mb4
```
