<?php

namespace platyFramework;

/**
 * ptyCliColor - CLI 색상 상수 정의 클래스
 *
 * 터미널에서 사용할 수 있는 다양한 색상 상수를 제공합니다.
 */
class ptyCliColor
{
    // 기본 색상 (밝은 색상)
    const LIGHT_WHITE = "\033[1;37m";         // 밝은 흰색
    const RED = "\033[1;31m";           // 밝은 빨간색
    const GREEN = "\033[1;32m";         // 밝은 녹색
    const YELLOW = "\033[1;33m";        // 밝은 노란색
    const BLUE = "\033[1;34m";          // 밝은 파란색
    const MAGENTA = "\033[1;35m";       // 밝은 보라색
    const CYAN = "\033[1;36m";          // 밝은 청록색
    const BLACK = "\033[1;30m";         // 밝은 검정색 (회색)

    // 일반 색상 (어두운 색상)
    const DARK_WHITE = "\033[0;37m";    // 어두운 흰색
    const DARK_RED = "\033[0;31m";      // 어두운 빨간색
    const DARK_GREEN = "\033[0;32m";    // 어두운 녹색
    const DARK_YELLOW = "\033[0;33m";   // 어두운 노란색
    const DARK_BLUE = "\033[0;34m";     // 어두운 파란색
    const DARK_MAGENTA = "\033[0;35m";  // 어두운 보라색
    const DARK_CYAN = "\033[0;36m";     // 어두운 청록색
    const DARK_BLACK = "\033[0;30m";    // 어두운 검정색

    // 배경 색상
    const BG_WHITE = "\033[47m";        // 흰색 배경
    const BG_RED = "\033[41m";          // 빨간색 배경
    const BG_GREEN = "\033[42m";        // 녹색 배경
    const BG_YELLOW = "\033[43m";       // 노란색 배경
    const BG_BLUE = "\033[44m";         // 파란색 배경
    const BG_MAGENTA = "\033[45m";      // 보라색 배경
    const BG_CYAN = "\033[46m";         // 청록색 배경
    const BG_BLACK = "\033[40m";        // 검정색 배경

    // 특수 스타일
    const BOLD = "\033[1m";             // 굵게
    const DIM = "\033[2m";              // 흐리게
    const ITALIC = "\033[3m";           // 기울임
    const UNDERLINE = "\033[4m";        // 밑줄
    const BLINK = "\033[5m";            // 깜빡임
    const REVERSE = "\033[7m";          // 반전
    const HIDDEN = "\033[8m";           // 숨김

    // 리셋
    const RESET = "\033[0m";            // 모든 스타일 리셋

    // 자주 사용하는 조합 색상
    const SUCCESS = self::GREEN;        // 성공 (녹색)
    const ERROR = self::RED;            // 에러 (빨간색)
    const WARNING = self::YELLOW;       // 경고 (노란색)
    const INFO = self::CYAN;            // 정보 (청록색)
    const DEBUG = self::MAGENTA;        // 디버그 (보라색)

    /**
     * 텍스트에 색상 적용
     *
     * @param string $text 텍스트
     * @param string $color 색상 상수
     * @return string 색상이 적용된 텍스트
     */
    public static function colorize($text, $color)
    {
        return $color . $text . self::RESET;
    }

    /**
     * 사용 가능한 모든 색상 출력
     */
    public static function showAllColors()
    {
        $colors = [
            'WHITE' => self::WHITE,
            'RED' => self::RED,
            'GREEN' => self::GREEN,
            'YELLOW' => self::YELLOW,
            'BLUE' => self::BLUE,
            'MAGENTA' => self::MAGENTA,
            'CYAN' => self::CYAN,
            'BLACK' => self::BLACK,
        ];

        echo "\n=== 밝은 색상 ===\n";
        foreach ($colors as $name => $code) {
            echo self::colorize("$name: This is a sample text", $code) . "\n";
        }

        echo "\n=== 어두운 색상 ===\n";
        $darkColors = [
            'DARK_WHITE' => self::DARK_WHITE,
            'DARK_RED' => self::DARK_RED,
            'DARK_GREEN' => self::DARK_GREEN,
            'DARK_YELLOW' => self::DARK_YELLOW,
            'DARK_BLUE' => self::DARK_BLUE,
            'DARK_MAGENTA' => self::DARK_MAGENTA,
            'DARK_CYAN' => self::DARK_CYAN,
            'DARK_BLACK' => self::DARK_BLACK,
        ];

        foreach ($darkColors as $name => $code) {
            echo self::colorize("$name: This is a sample text", $code) . "\n";
        }

        echo "\n=== 자주 사용하는 조합 ===\n";
        echo self::colorize("SUCCESS: 작업이 성공적으로 완료되었습니다.", self::SUCCESS) . "\n";
        echo self::colorize("ERROR: 오류가 발생했습니다.", self::ERROR) . "\n";
        echo self::colorize("WARNING: 경고 메시지입니다.", self::WARNING) . "\n";
        echo self::colorize("INFO: 정보 메시지입니다.", self::INFO) . "\n";
        echo self::colorize("DEBUG: 디버그 메시지입니다.", self::DEBUG) . "\n";
    }
}