<?php

namespace platyFramework;

//require_once("./db.php");
//require_once("./Elastic.php");
//require_once("./ptyCliLog.php");

ini_set('memory_limit', '2G');
ini_set('max_execution_time', '0');
set_time_limit(0);


require_once(__DIR__ . "/../elastic/Elastic.php");

class SomeEmbeddingItemModel extends ptyItemModel
{
    public function processVectorEmbeddingItems($embeddingItemsModel)
    {
        $log = new ptyCliLog(prefix: "임베딩 처리", color: ptyCliLog::COLOR_GREEN);

        $this->embeddingStatus = "IN_PROGRESS_EMBEDDING";
        $this->updateWithItemName("embeddingStatus");

        $chunks = json_decode($this->chunks, true);
        $log->info("docId: {$this->docId}, documentTitle: $this->title, docIndex: $this->docIndex, total chunk count = ".count($chunks));

        // embeddings 수집
        $embeddings = [];
        if (true) {
            // $oldItem = $this->db->sqlFetchItem("select * from new_law_items_embedding_all where docId = '{$this->docId}'");
            $chunkText = mre($this->chunks);
            $q = "select * from new_law_items_embedding_all where chunk_crc = CRC32('$chunkText') AND chunk_sha = UNHEX(SHA2('$chunkText', 256))";
            // $log->info("Query = $q");
            $oldItem = $this->db->sqlFetchItem($q);
            if ($oldItem != null && $oldItem->embeddings != "[]" && $oldItem->embeddings != "") {
                $log->info("기존 임베딩에 존재함.");
                $embeddings = json_decode($oldItem->embeddings, true);
            }
        }

        // 기존 임베딩이 없으면 생성
        if (count($embeddings) == 0) {
            foreach ($chunks as $chunkIndex => $chunk) {
                $log->info("embedding. documentTitle: $this->title, docIndex: $this->docIndex, current chunkIndex: $chunkIndex");

                $embedding = $embeddingItemsModel->getClaudeVoyage3largeVectorEmbedding($chunk);
                $embeddings [] = $embedding;
            }
        }

        if (count($embeddings) == 0) {
            $this->embeddings = json_encode($embeddings, JSON_UNESCAPED_UNICODE);
            $this->embeddingStatus = "FAILURE_EMBEDDING";
            $this->updateWithItemName(["embeddings", "embeddingStatus"]);
            return;
        }

        // elastic 에 기록
        foreach ($chunks as $chunkIndex => $chunk) {
            $log->info("elastic. documentTitle: $this->title, docIndex: $this->docIndex, current chunkIndex: $chunkIndex");

            // 개별 chunk 마다 recordElastic 을 기록
            $embeddingItemsModel->recordElastic(
                serviceName: $this->serviceName,
                serviceId: $this->serviceId,
                documentTitle: $this->title,
                docIndex: $this->docIndex,
                chunkIndex: $chunkIndex,
                chunk: $chunk,
                embedding: $embeddings[$chunkIndex],
            );
        }

        $this->embeddings = json_encode($embeddings, JSON_UNESCAPED_UNICODE);
        $this->embeddingStatus = "SUCCESS_ELASTIC";
        $this->updateWithItemName(["embeddings", "embeddingStatus"]);
    }
}

?>