<?php
/**
 * ptyCliOptionParser
 *
 * 커맨드라인 옵션 파서
 */

namespace platyFramework;

class ptyCliOptionParser
{
    /**
     * argv에서 위치 인자와 옵션을 분리
     *
     * @param array $argv
     * @return array [positional => [], options => []]
     */
    public static function parse($argv)
    {
        $positionalArgs = [];
        $options = [];

        foreach ($argv as $i => $arg) {
            if ($i === 0) continue; // 스크립트 이름 제외

            if (strpos($arg, '--') === 0) {
                if (preg_match('/^--([^=]+)=(.*)$/', $arg, $matches)) {
                    $options[$matches[1]] = $matches[2];
                } elseif (preg_match('/^--([^=]+)$/', $arg, $matches)) {
                    $options[$matches[1]] = true;
                }
            } else {
                $positionalArgs[] = $arg;
            }
        }

        return [
            'positional' => $positionalArgs,
            'options' => $options,
        ];
    }
}
