<?php
namespace platyFramework;

/*
ex)
$form = new \ptyForms("product_modify", $item, "item");
		$data = $form->getRealDataFromRequest();
*/


class ptyForms2
{

	var $prefix;
	var $items;
	var $formGroupName;
	var $names;
	/** @var ptyFormFileManager $fileManager */
	var $fileManager;

	function __construct($prefix, $items, $formGroupName)
	{
		$this->prefix = $prefix;
		$this->items = $items;
		$this->formGroupName = $formGroupName;
		$this->names = array();
		$this->fileManager = new ptyfileListModel();
	}

	static function build($prefix, $items, $formGroupName)
	{
		$class = new static($prefix, $items, $formGroupName);
		return $class;
	}

	function setFileManager($fileManager)
	{
		// $this->fileManager = $fileManager;
		return $this;
	}

	function getRealDataFromRequest()
	{
		GLOBAL $platyFramework;

		$names = $_SESSION["ptyForms"][$this->prefix][$this->formGroupName];

		$values = array();
		foreach ($names as $no => $value) {

			$inputName = $value['name'];
			$data = $platyFramework->request->request[$this->formGroupName][$inputName];
			// if (is_null($data))				$data = '';

			$type = $_SESSION["ptyForms"][$this->prefix][$this->formGroupName][$no]['type'];

			// 배열 형식의 checkbox 일 경우의 처리
			if ($type == "inputCheckbox" && is_array($data)) {
				$values[$inputName] = "|" . implode("|", $data) . "|";
			}
			else if ($type == "inputCheckbox" && !is_array($data)) {
				$values[$inputName] = "";
			} else if ($type == "inputFile") {
				// inputFile 은 값을 우선 추가하지 않음
			} else {
				$values[$inputName] = $data;
			}
		}

//		ptyDebug($values); exit;
		return $values;
	}

//
//	function getNames(&$names)
//	{
//		$names = array();
//		foreach ($this->items as $item) {
//			$subNames = array();
//			$item->getNames($this->prefix, $subNames);
//			$names = array_merge($names, $subNames);
//		}
//
//		return $names;
//	}


	function __destruct()
	{
// form 을 생성한 기록이 있다면 세션에 기록
		if (count($this->names))
			$_SESSION["ptyForms"][$this->prefix][$this->formGroupName] = $this->names;
	}

	function clear()
	{
		$_SESSION["ptyForms"][$this->prefix][$this->formGroupName] = "";
	}

	function getLabel($label, $name, $style = "", $additional = "")
	{
		if (!$name) $name = $label;
		$inputValue = $this->items->$name;
		// $inputValue = nl2br(htmlspecialchars($inputValue, ENT_QUOTES));
		// $inputValue = nl2br(stripslashes(htmlspecialchars($inputValue, ENT_QUOTES)));
		$inputValue = nl2br(stripslashes($inputValue));

		$out = "
<div class='form-group'>
	<label class=\"col-sm-2 control-label\">$label</label>
	<div class=\"col-sm-10\">
		<p $style type='text' id='$name' name='$inputName' placeholder='' class='form-control' style='border: 1px solid #ffffff; height: auto;' >
			$inputValue
		</p>
	</div>
</div>
";

		return $out;
	}

	function getCheckBox($label, $name = "", $checks = "")
	{
		$out = "<div class='form-group'>";
		$out .= "<label class=\"col-sm-2 control-label\">$label</label>";
		$out .= "<div class='col-sm-10'>";

		$out .= $this->getCheckboxRaw($name, $checks);

		$out .= "</div></div>";
		return $out;

	}

	function getCheckboxRaw($name = "", $checks)
	{
		$inputName = sprintf("%s[%s][]", $this->formGroupName, $name);
		$inputValue = $this->items->$name;
		$this->names[] = array("name" => $name, "type" => "inputCheckbox");
		$inputValue = htmlspecialchars($inputValue, ENT_QUOTES);
		// $inputValues = explode("|", $inputValue);

		// ptyDebug($inputValues);

		foreach ($checks as $k => $v) {
			$checked = strstr($inputValue, "|" . $v . "|") ? "checked" : "";
//			ptyDebug($inputValue);
//			ptyDebug($v);

			$out .= "<div class='col-sm-2 checkbox no-padding'>";
			$out .=
				"
                    <label>
                      <input type=\"checkbox\" name='$inputName' id='" . $name . "_$v' value='$v' $checked>
                      $k
                    </label>
                    ";
			$out .= "</div>";
		}

		return $out;
	}


	// done
	function getRadioRaw($name = "", $checks)
	{
		$inputName = sprintf("%s[%s]", $this->formGroupName, $name);
		$inputValue = $this->items->$name;
		$this->names[] = array("name" => $name, "type" => "inputRadio");
		$inputValue = htmlspecialchars($inputValue, ENT_QUOTES);

		foreach ($checks as $k => $v) {
			$out .= "<div class='col-sm-2 radio no-padding'>";

			$checked = $v == $inputValue ? "checked" : "";
			$out .=
				"
                    <label>
                      <input type=\"radio\" name='$inputName' id='" . $name . "_$k' value='$v' $checked>
                      $k
                    </label>
                    ";
			$out .= "</div>";
		}

		return $out;
	}

	function getDate($label, $name)
	{
		if (!$name) $name = $label;
		$inputName = sprintf("%s[%s]", $this->formGroupName, $name);
		$inputValue = $this->items->$name;
		$this->names[] = array("name" => $name, "type" => "inputText");
		$inputValue = htmlspecialchars($inputValue, ENT_QUOTES);

		$out = "
<div class='form-group'>
	<label class='col-sm-2 control-label'>$label</label>
	<div class='col-sm-8'>
		<div class='input-group date'>
			<div class='input-group-addon'>
				<i class='fa fa-calendar'></i>
			</div>
			<input type='text' class='form-control pull-right ptyDatePicker'>
		</div>
	</div>
</div>
		";

		return $out;
	}

	function getDateRange($label, $name1, $name2)
	{
		$inputName1 = sprintf("%s[%s]", $this->formGroupName, $name1);
		$inputName2 = sprintf("%s[%s]", $this->formGroupName, $name2);
		$inputValue1 = $this->items->$name1;
		$inputValue2 = $this->items->$name2;
		$this->names[] = array("name" => $name1, "type" => "inputText");
		$this->names[] = array("name" => $name2, "type" => "inputText");

		$inputValue1 = htmlspecialchars($inputValue1, ENT_QUOTES);
		$inputValue2 = htmlspecialchars($inputValue2, ENT_QUOTES);

		$out = "
<div class='form-group'>
	<label class='col-sm-2 control-label'>$label</label>
	<div class='col-sm-4'>
		<div class='input-group date'>
			<div class='input-group-addon'>
				<i class='fa fa-calendar'></i>
			</div>
			<input type='text' name='$inputName1' value='$inputValue1' class='form-control pull-right ptyDatePicker'>
		</div>
	</div>
	<div class='col-sm-1'>
	~
	</div>
	<div class='col-sm-4'>
		<div class='input-group date'>
			<div class='input-group-addon'>
				<i class='fa fa-calendar'></i>
			</div>
			<input type='text' name='$inputName2' value='$inputValue2' class='form-control pull-right ptyDatePicker''>
		</div>
	</div>
</div>
		";

		return $out;
	}

	function addNames($name, $type = "inputText")
	{
		$this->names[] = array("name" => $name, "type" => "inputText");
		return $this;
	}

	function getInputRaw($name = "", $style = "", $placeholder = "")
	{
		$inputName = sprintf("%s[%s]", $this->formGroupName, $name);
		$inputValue = $this->items->$name;
		$this->names[] = array("name" => $name, "type" => "inputText");
		$inputValue = htmlspecialchars($inputValue, ENT_QUOTES);

		return "<input $style type='text' id='$name' name='$inputName' value='$inputValue' placeholder='$placeholder' class='form-control'>";
	}



	function getInput($label, $name = "", $style = "", $additional = "")
	{
		if (!$name) $name = $label;
		$inputName = sprintf("%s[%s]", $this->formGroupName, $name);
		$inputValue = $this->items->$name;
		$this->names[] = array("name" => $name, "type" => "inputText");
		$inputValue = htmlspecialchars($inputValue, ENT_QUOTES);

		$out = "
<div class='form-group'>
	<label class=\"col-sm-2 control-label\">$label</label>
	";

		if ($additional) {
			$out .= "
	<div class='col-sm-8'>
		<input $style type='text' id='$name' name='$inputName' value='$inputValue' placeholder='' class='form-control' xstyle='width: 90%; display: inline-block' >
	</div>
	<div class=''col-sm-4'>
		$additional
	</div>
	";
		} else {
			$out .= "
	<div class='col-sm-10'>
		<input $style type='text' id='$name' name='$inputName' value='$inputValue' placeholder='' class='form-control' xstyle='width: 90%; display: inline-block' >
	</div>
	";

		}

		$out .= "
</div>
";

		return $out;
	}

	function getFile($label, $name, $position = 0)
	{
		if (!$name) $name = $label;
		$inputName = sprintf("%s[%s]", $this->formGroupName, $name);
		$deleteName = sprintf("%s[attach_delete][%s]", $this->formGroupName, $name);
		$inputValue = $this->items->$name;
		$this->names[] = array("name" => $name, "type" => "inputFile");
		$inputValue = htmlspecialchars($inputValue, ENT_QUOTES);

		$out = "
<div class='form-group'>
	<label class=\"col-sm-2 control-label\">$label</label>
	<div class=\"col-sm-10\">
		<input $style type='file' multiple id='$name' name='$inputName' value='$inputValue' placeholder='' class='form-control' xstyle='width: 90%; display: inline-block' >
		";
		{
			$url = "";
			$inputValue = $this->items->$name;
			if ($this->items->id != "") {
				$url = $this->fileManager->getUrl($this->prefix, $this->items->id, $name, $position, $imageId);
			}
			if ($url) {
				$out .= "<p><img src='$url' width=30%>
			<label><input type=checkbox name=$deleteName value=$imageId> 이미지 삭제</label></p>";
			}
		}

		$out .=
			"
		$additional
	</div>
</div>

";
		return $out;


	}

	function getFiles($label, $name, $position = 0)
	{
		if (!$name) $name = $label;
		$inputName = sprintf("%s[%s][]", $this->formGroupName, $name);
		$deleteName = sprintf("%s[%s_delete][]", $this->formGroupName, $name);
		$inputValue = $this->items->$name;
		$this->names[] = array("name" => $name, "type" => "inputFile");
		$inputValue = htmlspecialchars($inputValue, ENT_QUOTES);

		$out = "
<div class='form-group'>
	<label class=\"col-sm-2 control-label\">$label</label>
	<div class=\"col-sm-10\">
		<input $style type='file' multiple id='$name' name='$inputName' value='$inputValue' placeholder='' class='form-control' xstyle='width: 90%; display: inline-block' >
		";
		{
			$url = "";
			$inputValue = $this->items->$name;
			if ($this->items->id)
				$url = $this->fileManager->getUrl($this->prefix, $this->items->id, $name, $position, $imageId);
			if ($url) {
				$out .= "<p><img src='$url' width=30%>
			<label><input type=checkbox name=$deleteName value=$imageId> 이미지 삭제</label></p>";
			}
		}

		$out .=
			"
		$additional
	</div>
</div>

";
		return $out;


	}


	function getSelectRaw($name = "", $selects, $style = "")
	{
		$inputName = sprintf("%s[%s]", $this->formGroupName, $name);
		$inputValue = $this->items->$name;
		$this->names[] = array("name" => $name, "type" => "select");
		$inputValue = htmlspecialchars($inputValue, ENT_QUOTES);

		$out = "";
		$out .= "<select $style id='$name' name='$inputName' class=\"form-control\">";

		foreach ($selects as $k => $v) {
			$selected = $v == $inputValue ? " selected" : "";
			$out .= "<option$selected value='$v'>$k</option>";
		}

		$out .= "</select>";

		return $out;
	}

	function getSelect($label, $name = "", $selects, $style = "", $additional = "")
	{
		if (!$name) $name = $label;
		$inputName = sprintf("%s[%s]", $this->formGroupName, $name);
		$inputValue = $this->items->$name;
		$this->names[] = array("name" => $name, "type" => "select");
		$inputValue = htmlspecialchars($inputValue, ENT_QUOTES);

		$out = "
<div class='form-group'>
	<label class=\"col-sm-2 control-label\">$label</label>
	";

		$out .= $additional ? "<div class=\"col-sm-9\">" : "<div class=\"col-sm-10\">";
		$out .= "
			<select $style id='$name' name='$inputName' class=\"form-control\">";

		foreach ($selects as $k => $v) {
			$selected = $v == $inputValue ? " selected" : "";
			$out .= "<option$selected value='$v'>$k</option>";
		}

		$out .= "
			</select>
		</div>
		";

		$out .= $additional ? "<div class=\"col-sm-1\">$additional</div>" : "";
		$out .= "
	</div>
	";

		return $out;
	}

	function getRadio($label, $name = "", $selects, $style = "", $additional = "")
	{
		if (!$name) $name = $label;
		$inputName = sprintf("%s[%s]", $this->formGroupName, $name);
		$inputValue = $this->items->$name;
		$this->names[] = array("name" => $name, "type" => "select");
		$inputValue = htmlspecialchars($inputValue, ENT_QUOTES);

		$out = "
<div class='form-group'>
	<label class=\"col-sm-2 control-label\">$label</label>
	";

		$out .= $additional ? "<div class=\"col-sm-9\">" : "<div class=\"col-sm-10\">";

		foreach ($selects as $k => $v) {
			$selected = $v == $inputValue ? " checked='checked'" : "";
			$out .= "<div class='radio col-sm-3'><label><input type='radio' $style id='$name' name='$inputName' $selected value='$v'>$k</label></div>";
		}

		$out .= "
			</select>
		</div>
		";

		$out .= $additional ? "<div class=\"col-sm-1\">$additional</div>" : "";
		$out .= "
	</div>
	";

		return $out;
	}


	function getTextEdit($label, $name = "")
	{
		GLOBAL $ckeditorInit;

		if (!$ckeditorInit) {
			/*
			echo "
			<script>
				CKEDITOR.config.startupMode = 'wysiwyg';
				CKEDITOR.config.allowedContent = true;
			</script>
			";
			*/
			$ckeditorInit = true;
		}

		if (!$name) $name = $label;
		$inputName = sprintf("%s[%s]", $this->formGroupName, $name);
		$inputValue = $this->items->$name;
		$this->names[] = array("name" => $name, "type" => "textArea");

		$out = "
	<div class='form-group'>
		<label class=\"col-sm-2 control-label\">$label</label>
		<div class=\"col-sm-10\">
			<textarea id='$name' name='$inputName' class='ckeditor'>$inputValue</textarea>
			$additional
		</div>
	</div>
	";

		return $out;
	}

	function addHidden($name)
	{
		$this->names[] = array("name" => $name, "type" => "hidden");
	}

	static function getSelectOptions($selects, $value, $style = "")
	{
		foreach ($selects as $k => $v) {
			$selected = $v == $value ? " selected" : "";
			$out .= "<option$selected value='$v'>$k</option>";
		}
		return $out;
	}

}

?>