<?php
namespace platyFramework;

require_once __DIR__.'/ptyLibrary.php';
require_once __DIR__.'/cli/ptyCliLog.php';

// log 를 생성하세요
// $log = new ptyCliLog(prefix: "법령 임베딩 (LAW)", color: ptyCliLog::COLOR_GREEN);

try {
    $dsn = sprintf(
        'mysql:host=%s;dbname=%s;charset=%s',
        PLATYFRAMEWORK_DB_HOSTNAME,
        PLATYFRAMEWORK_DB_DATABASE,
        PLATYFRAMEWORK_DB_CHARSET
    );

    $pdo = new \PDO(
        $dsn,
        PLATYFRAMEWORK_DB_USERNAME,
        PLATYFRAMEWORK_DB_PASSWORD,
        [
            \PDO::ATTR_ERRMODE => \PDO::ERRMODE_EXCEPTION,
            \PDO::ATTR_DEFAULT_FETCH_MODE => \PDO::FETCH_ASSOC,
            \PDO::ATTR_EMULATE_PREPARES => false,
            \PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES " . PLATYFRAMEWORK_DB_CHARSET . " COLLATE " . PLATYFRAMEWORK_DB_COLLATE,
        ]
    );

    echo "데이터베이스 연결 성공!\n";

} catch (PDOException $e) {
    die('연결 실패: ' . $e->getMessage());
}

class platyFramework
{
    var $_item = array();

    public function __get($key)
    {
        if (isset($this->_item[$key])) {
            return $this->_item[$key];
        }

        return NULL;
    }

    public function __set($key, $value)
    {
        $this->_item[$key] = $value;
    }
}

$platyFramework = new platyFramework();

$platyFramework->db = new ptyMysql(
    PLATYFRAMEWORK_DB_HOSTNAME,
    PLATYFRAMEWORK_DB_USERNAME,
    PLATYFRAMEWORK_DB_PASSWORD,
    PLATYFRAMEWORK_DB_DATABASE);


