<?php

include_once 'xmlrpc.inc';

class ptyPostBlog
{
    private $api_provider;
    private $api_url;
    private $blog_id;
    private $user_id;
    private $api_pw;
    
    //--------------------------------------------------------------------------
    // 초기화 함수     : 블로그를 연결하기 위한 정보를 설정한다.
    // $api_url     : 블로그 API URL, string
    // $blog_id     : 블로그 ID, string
    // $user_id     : 블로그 USER ID, string
    // $api_pw      : 블로그 API PW, string
    //--------------------------------------------------------------------------
    public function init ($api_provider, $api_url, $blog_id, $user_id, $api_pw)
    {
        $this->api_provider = $api_provider;
        $this->api_url = $api_url;
        $this->blog_id = $blog_id;
        $this->user_id = $user_id;
        $this->api_pw = $api_pw;
    }
    
    //--------------------------------------------------------------------------
    // 글 등록 함수
    // $categories  : 등록할 게시판 카테고리, string
    // $title       : 글 제목, string
    // $description : 글 내용, string
    // $publish     : 글 공개여부, boolean
    // $respStr     : 성공하면 Post id, 실패하면 error msg
    // return       : boolean
    //--------------------------------------------------------------------------
    public function newPost ($categories, $title, $description, $tags, $publish = true, &$respStr = "")
    {
        if (!isset($categories) || !isset($title) 
             || !isset($description)) 
        { 
            $respStr = "parameters null"; 
            return false; 
        }
        
        $client = new xmlrpc_client($this->api_url);
        
        $client->setSSLVerifyPeer(false); 
        $GLOBALS['xmlrpc_internalencoding']='UTF-8';
        
        $tag_key = (strcmp($this->api_provider, "네이버") == 0 ? 'tags' : 'mt_keywords');
        
        $content = array(
            'title' => new xmlrpcval($title, "string"), 
            'description' => new xmlrpcval($description, "string"),
            'dateCreated' => new xmlrpcval(date("Ymd\TH:i:s"), "dateTime.iso8601"), 
            'categories' => new xmlrpcval($categories, "string"),
            $tag_key => new xmlrpcval($tags, "string")
        );
        
        $msg = new xmlrpcmsg("metaWeblog.newPost", 
            array( 
                new xmlrpcval($this->blog_id, "string"),
                new xmlrpcval($this->user_id, "string"),
                new xmlrpcval($this->api_pw, "string"),
                new xmlrpcval($content , "struct"),
                new xmlrpcval($publish, "boolean")));
        $msg->request_charset_encoding = 'UTF-8';
        $response = $client->send($msg);

		if (0)
		{
			print_r($msg);
			print_r($response); 
			exit;
		}
        
        return $this->responseValue($response, $respStr);
    }
    
    //--------------------------------------------------------------------------
    // 글 수정 함수
    // $postid      : 수정할 글의 id, string
    // $categories  : 등록할 게시판 카테고리, string
    // $title       : 글 제목, string
    // $description : 글 내용, string
    // $publish     : 글 공개여부, boolean
    // $respStr     : 성공하면 1, 실패하면 error msg
    // return       : boolean
    //--------------------------------------------------------------------------
    public function editPost ($postid, $categories, $title, $description, $tags, $publish = true, &$respStr = "")
    {
        if (!isset($postid) || !isset($categories) 
            || !isset($title) || !isset($description)) 
        {
            $respStr = "parameters null"; 
            return false;
        }
        
        $client = new xmlrpc_client($this->api_url);
        
        $client->setSSLVerifyPeer(false); 
        $GLOBALS['xmlrpc_internalencoding']='UTF-8';
        
        $tag_key = (strcmp($this->api_provider, "네이버") == 0 ? 'tags' : 'mt_keywords');
         
        $content = array(
            'title' => new xmlrpcval($title, "string"), 
            'description' => new xmlrpcval($description, "string"), 
            'categories' => new xmlrpcval($categories, "string"),
            $tag_key => new xmlrpcval($tags, "string")
        );
        
        $msg = new xmlrpcmsg("metaWeblog.editPost", 
            array( 
                new xmlrpcval($postid, "string"),
                new xmlrpcval($this->user_id, "string"),
                new xmlrpcval($this->api_pw, "string"),
                new xmlrpcval($content , "struct"),
                new xmlrpcval($publish, "boolean")));
        $msg->request_charset_encoding = 'UTF-8';
        $response = $client->send($msg);
        
        return $this->responseValue($response, $respStr);
    }
    
    //--------------------------------------------------------------------------
    // 글 삭제 함수
    // $postid      : 수정할 글의 id
    // $respStr     : 성공하면 1, 실패하면 error msg
    // return       : boolean
    //--------------------------------------------------------------------------
    public function deletePost ($postid, &$respStr = "")
    {
        if (!isset($postid)) 
        { 
            $respStr = "parameters null"; 
            return false; 
        }
        
        // 무시되는 입력값, 아무값이나 넣으면 된다.
        $appkey = "1111";
        $publish = true;  
        
        $client = new xmlrpc_client($this->api_url);
        
        $client->setSSLVerifyPeer(false); 
        $GLOBALS['xmlrpc_internalencoding']='UTF-8';

        $msg = new xmlrpcmsg("blogger.deletePost", 
            array( 
                new xmlrpcval($appkey, "string"),
                new xmlrpcval($postid, "string"),
                new xmlrpcval($this->user_id, "string"),
                new xmlrpcval($this->api_pw, "string"),
                new xmlrpcval($publish, "boolean")));
        $msg->request_charset_encoding = 'UTF-8';
        $response = $client->send($msg);
        
        return $this->responseValue($response, $respStr);
    }
    
    //--------------------------------------------------------------------------
    // 파일 업로드 함수
    // $file        : 첨부파일 정보, array('name', 'type', 'data')
    // $respStr     : 성공하면 file url, 실패하면 error msg
    // return       : boolean
    //--------------------------------------------------------------------------
    public function uploadFile ($file, &$respStr = "")
    {
        if (!isset($file) || gettype($file) != "array")
        { 
            $respStr = "parameters null"; 
            return false; 
        }
        
        $client = new xmlrpc_client($this->api_url);
        
        $client->setSSLVerifyPeer(false); 
        $GLOBALS['xmlrpc_internalencoding']='UTF-8';
        
        $content = array (
            'name' => new xmlrpcval($file['name'], "string"),
            'type' => new xmlrpcval($file['type'], "string"),
            'bits' => new xmlrpcval($file['data'], "base64")
        );

        $msg = new xmlrpcmsg("metaWeblog.newMediaObject",
            new xmlrpcval($this->blog_id, "string"),
            new xmlrpcval($this->user_id, "string"),
            new xmlrpcval($this->api_pw, "string"),
            new xmlrpcval($content, "struct")
        );
        $msg->request_charset_encoding = 'UTF-8';
        $response = $client->send($msg);
        
        return $this->responseValue($response, $respStr);
    }
    
    //--------------------------------------------------------------------------
    // 결과 확인
    // $response    : send를 해서 넘어온 결과, xmlrpcresp object
    // $respStr     : 결과 내용
    // return       : boolean
    //--------------------------------------------------------------------------
    private function responseValue($response, &$respStr = "")
    {
        if (isset($response))
        {
            if (strcmp(gettype($response), "object") == 0)
            {
                if ($response->faultCode())
                {
                    $respStr = $response->faultString(); 
                }
                else
                {
                    $respStr = $response->value()->scalarval();
                    return true;
                }
            }
            else
            {
                $respStr = "response 0";
            }
        }
        else
        {
            $respStr = "response null";
        }
        
        return false;
    }
    
}


?>
